/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.derive.session;

import com.onehilltech.promises.Promise;
import java.math.BigInteger;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Types;
import org.polkadot.api.derive.chain.ChainFunctions;
import org.polkadot.types.codec.Option;
import org.polkadot.types.type.BlockNumber;

public class SessionFunctions {
    public static Types.DeriveRealFunction eraLength(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return Promise.all((Promise[])new Promise[]{(Promise)((Types.QueryableStorageFunction)api.query().section("session").function("sessionLength")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("staking").function("sessionsPerEra")).call(new Object[0])}).then(results -> {
                    BlockNumber sessionLength = results.size() > 0 && results.get(0) != null ? (BlockNumber)results.get(0) : new BlockNumber(BigInteger.ONE);
                    BlockNumber sessionsPerEra = results.size() > 1 && results.get(1) != null ? (BlockNumber)results.get(1) : new BlockNumber(BigInteger.ONE);
                    return Promise.value((Object)sessionLength.multiply(sessionsPerEra));
                });
            }
        };
    }

    public static Types.DeriveRealFunction sessionProgress(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return Promise.all((Promise[])new Promise[]{ChainFunctions.bestNumber(api).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("session").function("sessionLength")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("session").function("lastLengthChange")).call(new Object[0])}).then(results -> {
                    BlockNumber bestNumber = (BlockNumber)results.get(0);
                    BlockNumber sessionLength = (BlockNumber)results.get(1);
                    Option lastLengthChange = (Option)results.get(2);
                    BigInteger result = bestNumber.subtract((BigInteger)lastLengthChange.unwrapOr(BigInteger.ZERO)).add(sessionLength).mod(sessionLength);
                    return Promise.value((Object)result);
                });
            }
        };
    }

    public static Types.DeriveRealFunction eraProgress(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return Promise.all((Promise[])new Promise[]{SessionFunctions.sessionProgress(api).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("session").function("currentIndex")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("session").function("sessionLength")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("staking").function("lastEraLengthChange")).call(new Object[0]), (Promise)((Types.QueryableStorageFunction)api.query().section("staking").function("sessionsPerEra")).call(new Object[0])}).then(results -> {
                    BigInteger sessionProgress = (BigInteger)results.get(0);
                    BlockNumber currentIndex = (BlockNumber)results.get(1);
                    BlockNumber sessionLength = (BlockNumber)results.get(2);
                    BlockNumber lastEraLengthChange = (BlockNumber)results.get(3);
                    BlockNumber sessionsPerEra = (BlockNumber)results.get(4);
                    BigInteger result = currentIndex.subtract(lastEraLengthChange).mod(sessionsPerEra).multiply(sessionLength).add(sessionProgress);
                    return Promise.value((Object)result);
                });
            }
        };
    }
}

