/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections4.CollectionUtils;

public class EventEmitter {
    public Map<EventType, List<EventListener>> listeners = new ConcurrentHashMap<EventType, List<EventListener>>();

    public List<?> getEventNames() {
        throw new UnsupportedOperationException();
    }

    public List<EventListener> getListeners(String eventType) {
        throw new UnsupportedOperationException();
    }

    public int getListenerCount(String eventType) {
        throw new UnsupportedOperationException();
    }

    public boolean emit(EventType eventType, Object ... args) {
        List<EventListener> eventListeners = this.listeners.get(eventType);
        if (CollectionUtils.isEmpty(eventListeners)) {
            return false;
        }
        ArrayList onces = Lists.newArrayList();
        for (EventListener eventListener : eventListeners) {
            eventListener.onEvent(args);
            if (!eventListener.isOnce()) continue;
            onces.add(eventListener);
        }
        eventListeners.removeAll(onces);
        return true;
    }

    public EventEmitter on(EventType eventType, EventListener listener) {
        return this.on(eventType, listener, null);
    }

    public EventEmitter on(EventType eventType, EventListener listener, Object context) {
        List eventListeners = this.listeners.computeIfAbsent(eventType, e -> new CopyOnWriteArrayList());
        eventListeners.add(new EventListenerProxy(listener, context));
        return this;
    }

    public EventEmitter addListener(EventType eventType, EventListener listener, Object context) {
        return this.on(eventType, listener, context);
    }

    public EventEmitter once(EventType eventType, EventListener listener) {
        return this.once(eventType, listener, null);
    }

    public EventEmitter once(EventType eventType, EventListener listener, Object context) {
        List eventListeners = this.listeners.computeIfAbsent(eventType, e -> new CopyOnWriteArrayList());
        eventListeners.add(new EventListenerProxy(listener, context, true));
        return this;
    }

    public EventEmitter removeListener(EventType event, EventListener listener, Object context, boolean once) {
        throw new UnsupportedOperationException();
    }

    public EventEmitter off(EventType event, EventListener listener, Object context, boolean once) {
        throw new UnsupportedOperationException();
    }

    public EventEmitter removeAllListener(EventType eventType) {
        throw new UnsupportedOperationException();
    }

    static class EventListenerProxy
    implements EventListener {
        Object context;
        EventListener listener;
        boolean once = false;

        @Override
        public boolean isOnce() {
            return this.once;
        }

        EventListenerProxy(EventListener listener, Object context) {
            this(listener, context, false);
        }

        EventListenerProxy(EventListener listener, Object context, boolean once) {
            this.context = context;
            this.listener = listener;
            this.once = once;
        }

        @Override
        public void onEvent(Object ... args) {
            this.listener.onEvent(args);
        }
    }

    @FunctionalInterface
    public static interface EventListener {
        public void onEvent(Object ... var1);

        default public boolean isOnce() {
            return false;
        }
    }

    public static interface EventType {
    }
}

