/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.polkadot.common.NamedThreadFactory;

public class ExecutorsManager {
    private static final int CORE_COUNT = Runtime.getRuntime().availableProcessors();
    public static final ExecutorService main = Executors.newSingleThreadExecutor(new NamedThreadFactory("Main-Executor"));
    private static final ExecutorService commonExecutor = Executors.newFixedThreadPool(CORE_COUNT + 1, new NamedThreadFactory("General-Executor"));
    private static final ScheduledExecutorService commonScheduleExecutor = Executors.newScheduledThreadPool(CORE_COUNT, new NamedThreadFactory("Schedule-Executor"));
    public static final ExecutorService battle = Executors.newFixedThreadPool(CORE_COUNT << 1, new NamedThreadFactory("Battle-Executor"));

    public static Future<?> execute(Runnable r) {
        return commonExecutor.submit(r);
    }

    public static <T> Future<T> execute(Callable<T> r) {
        return commonExecutor.submit(r);
    }

    public static ScheduledFuture<?> schedule(Runnable r, long delay, TimeUnit tu) {
        return commonScheduleExecutor.schedule(r, delay, tu);
    }

    public static ScheduledFuture<?> schedule(ExecutorService es, Runnable r, long delay, TimeUnit tu) {
        return commonScheduleExecutor.schedule(() -> es.submit(r), delay, tu);
    }
}

