/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common.keyring;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.common.keyring.Pairs;
import org.polkadot.common.keyring.Types;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.common.keyring.address.Defaults;
import org.polkadot.common.keyring.pair.Index;
import org.polkadot.common.keyring.pair.Types;
import org.polkadot.example.TestingPairs;
import org.polkadot.utils.Utils;
import org.polkadot.utils.crypto.Nacl;
import org.polkadot.utils.crypto.Schnorrkel;
import org.polkadot.utils.crypto.Types;

public class Keyring
implements Types.KeyringInstance {
    private Pairs pairs;
    private String type;

    public Keyring(Types.KeyringOptions options) {
        if (options.type == null) {
            options.type = "ed25519";
        }
        this.pairs = new Pairs();
        this.type = options.type;
        Defaults.prefix = (byte)(Types.Prefix.contains(options.addressPrefix) ? options.addressPrefix : 42);
    }

    @Override
    public List<Types.KeyringPair> getPairs() {
        return this.pairs.all();
    }

    @Override
    public List<byte[]> getPublicKeys() {
        return this.pairs.all().stream().map(e -> e.publicKey()).collect(Collectors.toList());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public byte[] decodeAddress(Object encoded, boolean ignoreChecksum) {
        return AddressCodec.decodeAddress(encoded, ignoreChecksum, Defaults.prefix);
    }

    @Override
    public String encodeAddress(byte[] key) {
        return AddressCodec.encodeAddress(key);
    }

    @Override
    public void setAddressPrefix(int prefix) {
        assert (Types.Prefix.contains(prefix)) : "invalid prefix " + prefix;
        Defaults.prefix = (byte)prefix;
    }

    @Override
    public Types.KeyringPair addPair(Types.KeyringPair pair) {
        return this.pairs.add(pair);
    }

    @Override
    public Types.KeyringPair addFromAddress(String address, Types.KeyringPairMeta meta, byte[] encoded, String type, boolean ignoreChecksum) {
        byte[] publicKey = this.decodeAddress(address, ignoreChecksum);
        meta = meta == null ? new Types.KeyringPairMeta() : meta;
        Types.PairInfo pairInfo = new Types.PairInfo();
        pairInfo.setPublicKey(publicKey);
        return this.addPair(Index.createPair(type, pairInfo, meta, encoded));
    }

    @Override
    public Types.KeyringPair addFromJson(Types.KeyringPairJson pair, boolean ignoreChecksum) {
        String version = pair.getEncoding().getVersion();
        String[] content = pair.getEncoding().getContent();
        String type = version.equals("0") || !content.getClass().isArray() ? this.type : content[1];
        return this.addFromAddress(pair.getAddress(), pair.getMeta(), Utils.hexToU8a(pair.getEncoded()), type, ignoreChecksum);
    }

    @Override
    public Types.KeyringPair addFromMnemonic(String mnemonic, Types.KeyringPairMeta meta, String type) {
        return this.addFromUri(mnemonic, meta, type);
    }

    @Override
    public Types.KeyringPair addFromSeed(byte[] seed, Types.KeyringPairMeta meta, String type) {
        meta = meta != null ? meta : new Types.KeyringPairMeta();
        type = StringUtils.isBlank((CharSequence)type) ? this.type : type;
        Types.Keypair keypair = type.equals("sr25519") ? Schnorrkel.schnorrkelKeypairFromSeed(seed) : Nacl.naclKeypairFromSeed(seed);
        Types.PairInfo pairInfo = new Types.PairInfo();
        pairInfo.setPublicKey(keypair.getPublicKey());
        pairInfo.setSecretKey(keypair.getSecretKey());
        return this.addPair(Index.createPair(type, pairInfo, meta, null));
    }

    @Override
    public Types.KeyringPair addFromUri(String suri, Types.KeyringPairMeta meta, String type) {
        return this.addPair(this.createFromUri(suri, meta, type));
    }

    @Override
    public Types.KeyringPair createFromUri(String _suri, Types.KeyringPairMeta meta, String type) {
        Pair<byte[], byte[]> keys = TestingPairs.getKeys(_suri.replace("//", ""));
        Types.PairInfo pairInfo = new Types.PairInfo();
        pairInfo.setPublicKey((byte[])keys.getLeft());
        pairInfo.setSecretKey((byte[])keys.getRight());
        Types.KeyringPair pair = Index.createPair(type, pairInfo, meta, null);
        return pair;
    }

    @Override
    public Types.KeyringPair getPair(String address) {
        return this.pairs.get(address);
    }

    @Override
    public void removePair(String address) {
        this.pairs.remove(address);
    }

    @Override
    public Types.KeyringPairJson toJson(String address, String passphrase) {
        return this.pairs.get(address).toJson(passphrase);
    }
}

