/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common.keyring;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public interface Types {
    public static final Set Prefix = Sets.newHashSet((Object[])new Integer[]{0, 1, 3, 42, 43, 68, 69});
    public static final List<String> KeyringPairJsonVersion = Lists.newArrayList((Object[])new String[]{"0", "1", "2"});

    public static interface KeyringInstance {
        public List<KeyringPair> getPairs();

        public List<byte[]> getPublicKeys();

        public String getType();

        public byte[] decodeAddress(Object var1, boolean var2);

        public String encodeAddress(byte[] var1);

        public void setAddressPrefix(int var1);

        public KeyringPair addPair(KeyringPair var1);

        public KeyringPair addFromAddress(String var1, KeyringPairMeta var2, byte[] var3, String var4, boolean var5);

        public KeyringPair addFromJson(KeyringPairJson var1, boolean var2);

        public KeyringPair addFromMnemonic(String var1, KeyringPairMeta var2, String var3);

        public KeyringPair addFromSeed(byte[] var1, KeyringPairMeta var2, String var3);

        public KeyringPair addFromUri(String var1, KeyringPairMeta var2, String var3);

        public KeyringPair createFromUri(String var1, KeyringPairMeta var2, String var3);

        public KeyringPair getPair(String var1);

        public void removePair(String var1);

        public KeyringPairJson toJson(String var1, String var2);
    }

    public static interface KeyringPairs {
        public KeyringPair add(KeyringPair var1);

        public List<KeyringPair> all();

        public KeyringPair get(String var1);

        public void remove(String var1);
    }

    public static interface KeyringPair {
        public String getType();

        public String address();

        public void decodePkcs8(String var1, byte[] var2);

        public byte[] encodePkcs8(String var1);

        public KeyringPairMeta getMeta();

        public boolean isLocked();

        public void lock();

        public byte[] publicKey();

        public void setMeta(KeyringPairMeta var1);

        public byte[] sign(byte[] var1);

        public KeyringPairJson toJson(String var1);

        public boolean verify(byte[] var1, byte[] var2);
    }

    public static class KeyringPairJson {
        String address;
        String encoded;
        KeyringPairJsonEncoding encoding;
        KeyringPairMeta meta;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getEncoded() {
            return this.encoded;
        }

        public void setEncoded(String encoded) {
            this.encoded = encoded;
        }

        public KeyringPairJsonEncoding getEncoding() {
            return this.encoding;
        }

        public void setEncoding(KeyringPairJsonEncoding encoding) {
            this.encoding = encoding;
        }

        public KeyringPairMeta getMeta() {
            return this.meta;
        }

        public void setMeta(KeyringPairMeta meta) {
            this.meta = meta;
        }
    }

    public static class KeyringPairJsonEncoding {
        String[] content;
        String type;
        String version;

        public String[] getContent() {
            return this.content;
        }

        public void setContent(String[] content) {
            this.content = content;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static class KeyringPairMeta
    extends LinkedHashMap<String, Object> {
    }

    public static class KeyringOptions {
        int addressPrefix = -1;
        String type;

        public KeyringOptions(String type) {
            this.type = type;
        }

        public int getAddressPrefix() {
            return this.addressPrefix;
        }

        public String getType() {
            return this.type;
        }
    }
}

