/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common.keyring.address;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.bitcoinj.core.Base58;
import org.polkadot.common.keyring.address.Defaults;
import org.polkadot.utils.Utils;
import org.polkadot.utils.UtilsCrypto;

public class AddressCodec {
    static final byte[] SS58_PREFIX = Utils.stringToU8a("SS58PRE");

    public static byte[] decodeAddress(Object encoded) {
        return AddressCodec.decodeAddress(encoded, false, Defaults.prefix);
    }

    public static byte[] decodeAddress(Object encoded, boolean ignoreChecksum) {
        return AddressCodec.decodeAddress(encoded, ignoreChecksum, Defaults.prefix);
    }

    public static byte[] decodeAddress(Object encoded, boolean ignoreChecksum, int prefix) {
        boolean checks;
        if (Utils.isU8a(encoded) || Utils.isHex(encoded)) {
            return Utils.u8aToU8a(encoded);
        }
        byte[] decoded = Base58.decode((String)((String)encoded));
        String errorPre = "Decoding " + encoded + ":";
        assert (Defaults.allowedEncodedLengths.contains(decoded.length)) : errorPre + "Invalid decoded address length " + decoded.length;
        boolean isPublicKey = decoded.length == 35;
        int endPos = decoded.length - (isPublicKey ? 2 : 1);
        byte[] hash = AddressCodec.sshash(ArrayUtils.subarray((byte[])decoded, (int)0, (int)endPos));
        boolean bl = isPublicKey ? decoded[decoded.length - 2] == hash[0] && decoded[decoded.length - 1] == hash[1] : (checks = decoded[decoded.length - 1] == hash[0]);
        assert (ignoreChecksum || checks) : errorPre + "Invalid decoded address checksum";
        return ArrayUtils.subarray((byte[])decoded, (int)1, (int)endPos);
    }

    public static byte[] sshash(byte[] key) {
        return UtilsCrypto.blake2AsU8a(Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{SS58_PREFIX, key})), 512);
    }

    public static String encodeAddress(byte[] key) {
        return AddressCodec.encodeAddress(key, Defaults.prefix);
    }

    public static String encodeAddress(byte[] _key, byte prefix) {
        byte[] key = Utils.u8aToU8a(_key);
        assert (Defaults.allowedDecodedLengths.contains(key.length)) : "Expected a valid key to convert, with length " + Defaults.allowedDecodedLengths + " : " + key.length;
        boolean isPublicKey = key.length == 32;
        byte[] input = Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{{prefix}, key}));
        byte[] hash = AddressCodec.sshash(input);
        byte[] bytes = Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{input, ArrayUtils.subarray((byte[])hash, (int)0, (int)(isPublicKey ? 2 : 1))}));
        String result = Base58.encode((byte[])bytes);
        return result;
    }
}

