/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common.keyring.pair;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.common.keyring.Types;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.common.keyring.pair.Defaults;
import org.polkadot.common.keyring.pair.Types;
import org.polkadot.utils.Utils;
import org.polkadot.utils.crypto.Nacl;

public class PairCodec {
    public static final int SEED_OFFSET = Defaults.PKCS8_HEADER.length;

    public static DecodeResult decode(String passphrase, byte[] encrypted) {
        byte[] encoded;
        assert (encrypted != null) : "No encrypted data available to decode";
        byte[] byArray = encoded = passphrase != null ? Nacl.naclDecrypt(ArrayUtils.subarray((byte[])encrypted, (int)24, (int)encrypted.length), ArrayUtils.subarray((byte[])encrypted, (int)0, (int)24), Utils.u8aFixLength(Utils.stringToU8a(passphrase), 256, true)) : encrypted;
        assert (encoded != null) : "Unable to unencrypt using the supplied passphrase";
        byte[] header = ArrayUtils.subarray((byte[])encoded, (int)0, (int)Defaults.PKCS8_HEADER.length);
        assert (Utils.u8aStrEq(header, Defaults.PKCS8_HEADER)) : "Invalid Pkcs8 header found in body";
        byte[] secretKey = ArrayUtils.subarray((byte[])encoded, (int)SEED_OFFSET, (int)(SEED_OFFSET + 64));
        int divOffset = SEED_OFFSET + 64;
        byte[] divider = ArrayUtils.subarray((byte[])encoded, (int)divOffset, (int)(divOffset + Defaults.PKCS8_DIVIDER.length));
        if (!Utils.u8aStrEq(divider, Defaults.PKCS8_DIVIDER)) {
            divOffset = SEED_OFFSET + 32;
            secretKey = ArrayUtils.subarray((byte[])encoded, (int)SEED_OFFSET, (int)divOffset);
            divider = ArrayUtils.subarray((byte[])encoded, (int)divOffset, (int)(divOffset + Defaults.PKCS8_DIVIDER.length));
        }
        assert (Utils.u8aStrEq(divider, Defaults.PKCS8_DIVIDER)) : "Invalid Pkcs8 divider found in body";
        int pubOffset = divOffset + Defaults.PKCS8_DIVIDER.length;
        byte[] publicKey = ArrayUtils.subarray((byte[])encoded, (int)pubOffset, (int)(pubOffset + 32));
        DecodeResult ret = new DecodeResult();
        ret.publicKey = publicKey;
        ret.secretKey = secretKey;
        return ret;
    }

    public static byte[] encode(Types.PairInfo pairInfo, String passphrase) {
        assert (pairInfo.getSecretKey() != null) : "Expected a valid secretKey to be passed to encode";
        byte[] encoded = Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{Defaults.PKCS8_HEADER, pairInfo.getSecretKey(), Defaults.PKCS8_DIVIDER, pairInfo.getPublicKey()}));
        if (passphrase == null) {
            return encoded;
        }
        Nacl.Encrypted encrypted = Nacl.naclEncrypt(encoded, Utils.u8aFixLength(Utils.stringToU8a(passphrase), 256, true));
        return Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{encrypted.getNonce(), encrypted.getEncrypted()}));
    }

    public static Types.KeyringPairJson toJson(String type, PairStateJson pairStateJson, byte[] encoded, boolean isEncryptede) {
        Types.KeyringPairJson result = new Types.KeyringPairJson();
        result.setAddress(AddressCodec.encodeAddress(pairStateJson.publicKey));
        result.setEncoded(Utils.u8aToHex(encoded));
        Types.KeyringPairJsonEncoding encoding = new Types.KeyringPairJsonEncoding();
        encoding.setContent(new String[]{"pkcs8", type.toString()});
        encoding.setType(isEncryptede ? "xsalsa20-poly1305" : "none");
        encoding.setVersion("2");
        result.setEncoding(encoding);
        result.setMeta(pairStateJson.meta);
        return result;
    }

    public static class PairStateJson {
        Types.KeyringPairMeta meta;
        byte[] publicKey;

        public PairStateJson(Types.KeyringPairMeta meta, byte[] publicKey) {
            this.meta = meta;
            this.publicKey = publicKey;
        }
    }

    public static class DecodeResult
    extends Types.PairInfo {
        byte[] secretKey;

        @Override
        public byte[] getSecretKey() {
            return this.secretKey;
        }

        @Override
        public void setSecretKey(byte[] secretKey) {
            this.secretKey = secretKey;
        }
    }
}

