/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example;

import com.onehilltech.promises.Promise;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.direct.ISection;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.rpc.ExtrinsicStatus;
import org.polkadot.types.type.BlockNumber;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.EventRecord;

public class Democracy {
    static String Alice = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static String endPoint = "ws://127.0.0.1:9944";
    static Object lock = new Object();

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Democracy.initEndPoint(args);
        Democracy.testReferendumInfoOf();
        Democracy.waitLock();
        Democracy.testReferendumVotesFor();
        Democracy.waitLock();
        Democracy.testVotingCountdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitLock() {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyLock() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    public static void testVote() {
        System.out.println("=========start testVote=========");
        Promise<ApiPromise> promise = Democracy.newApi();
        promise.then(api -> {
            Types.SubmittableExtrinsicFunction vote = (Types.SubmittableExtrinsicFunction)api.tx().section("democracy").function("vote");
            SubmittableExtrinsic call = vote.call(13, true);
            call.signAndSendCb(Alice, new SubmittableExtrinsic.StatusCb(){

                @Override
                public Object callback(SubmittableExtrinsic.SubmittableResult result) {
                    ExtrinsicStatus status = result.getStatus();
                    List<EventRecord> events = result.getEvents();
                    if (status.isFinalized()) {
                        System.out.println("Successful transfer  with hash " + status.asFinalized().toHex());
                    } else {
                        System.out.println("Status of transfer: " + status.getType());
                    }
                    System.out.println("Events");
                    for (EventRecord event : events) {
                        EventRecord.Phase phase = event.getPhase();
                        Event eventEvent = event.getEvent();
                        System.out.println("\t" + phase.toString() + ": " + eventEvent.getSection() + "." + eventEvent.getMethod() + " " + eventEvent.getData().toString());
                    }
                    return null;
                }
            });
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    static Promise<ApiPromise> newApi() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        return ready;
    }

    public static void testReferendumInfoOf() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        System.out.println("=========start testReferendumInfoOf=========");
        ready.then(api -> (Promise)((Types.QueryableStorageFunction)api.query().section("democracy").function("referendumInfoOf")).call(2, new IRpcFunction.SubscribeCallback<Object>(){

            @Override
            public void callback(Object codec) {
                System.out.println("referendumInfoOf callback : " + codec);
            }
        })).then(result -> {
            System.out.println("referendumInfoOf result  " + result);
            Democracy.notifyLock();
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    public static void testReferendumVotesFor() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        System.out.println("=========start testReferendumVotesFor=========");
        ready.then(api -> {
            ISection democracy = api.derive().section("democracy");
            Types.DeriveMethod function = (Types.DeriveMethod)democracy.function("referendumVotesFor");
            return (Promise)function.call(10, new IRpcFunction.SubscribeCallback(){

                public void callback(Object result) {
                    System.out.println("referendumVotesFor callback : " + result);
                }
            });
        }).then(result -> {
            System.out.println("referendumVotesFor result " + result);
            Democracy.notifyLock();
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    public static void testVotingCountdown() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        AtomicReference readyApi = new AtomicReference();
        System.out.println("=========start testVotingCountdown=========");
        ready.then(api -> {
            Types.QueryableStorage query = api.query();
            ISection democracy = query.section("democracy");
            Types.QueryableStorageFunction votingPeriod = (Types.QueryableStorageFunction)democracy.function("votingPeriod");
            Types.QueryableStorageFunction launchPeriod = (Types.QueryableStorageFunction)democracy.function("launchPeriod");
            readyApi.set(api);
            return Promise.all((Promise[])new Promise[]{(Promise)votingPeriod.call(new Object[0]), (Promise)launchPeriod.call(new Object[0])});
        }).then(results -> {
            BlockNumber votingPeriod = (BlockNumber)results.get(0);
            BlockNumber launchPeriod = (BlockNumber)results.get(1);
            System.out.println("@votingPeriod:" + votingPeriod);
            System.out.println("*launchPeriod:" + launchPeriod);
            ApiPromise api = (ApiPromise)readyApi.get();
            ISection chain = api.derive().section("chain");
            Types.DeriveMethod bestNumber = (Types.DeriveMethod)chain.function("bestNumber");
            return (Promise)bestNumber.call(o -> {
                System.out.println("SubscribeCallback : " + o);
                BlockNumber bestNum = (BlockNumber)o;
                BigInteger votingCountdown = votingPeriod.subtract(bestNum.mod(votingPeriod).add(BigInteger.ONE));
                BigInteger launchCountdown = launchPeriod.subtract(bestNum.mod(launchPeriod).add(BigInteger.ONE));
                System.out.println("@votingCountdown:" + votingCountdown);
                System.out.println("*launchCountdown:" + launchCountdown);
            });
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
    }
}

