/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example;

import com.alibaba.fastjson.JSON;
import com.onehilltech.promises.Promise;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.direct.ISection;
import org.polkadot.rpc.provider.ws.WsProvider;

public class Staking {
    static String Alice = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static String CHARLIE = "5FmE1Adpwp1bT1oY95w59RiSPVu9QwzBGjKsE2hxemD2AFs8";
    static String controller = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static String endPoint = "ws://127.0.0.1:9944";
    static Object lock = new Object();

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Staking.initEndPoint(args);
        Staking.testValidators();
        Staking.waitLock();
        Staking.testNominators();
        Staking.waitLock();
        Staking.testLedger();
        Staking.waitLock();
        Staking.testBonded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitLock() {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyLock() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    static void testValidators() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        ready.then(api -> {
            System.out.println("=========start testValidators=========");
            Types.QueryableStorage query = api.query();
            ISection staking = query.section("staking");
            Types.QueryableStorageFunction validators = (Types.QueryableStorageFunction)staking.function("validators");
            return Promise.all((Promise[])new Promise[]{(Promise)validators.call(controller)});
        }).then(result -> {
            for (Object ret : result) {
                System.out.println("validators : " + ret);
                System.out.println("validators : " + ret.getClass());
                System.out.println("validators :\n " + JSON.toJSONString(ret, (boolean)true));
                System.out.println(" =============");
            }
            Staking.notifyLock();
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
    }

    public static void testNominators() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        ready.then(api -> {
            System.out.println("=========start testNominators =========");
            Types.QueryableStorage query = api.query();
            ISection staking = query.section("staking");
            Types.QueryableStorageFunction nominators = (Types.QueryableStorageFunction)staking.function("nominators");
            return Promise.all((Promise[])new Promise[]{(Promise)nominators.call(controller)});
        }).then(result -> {
            for (Object ret : result) {
                System.out.println("nominators : " + ret);
                System.out.println("nominators : " + ret.getClass());
                System.out.println("nominators :\n " + JSON.toJSONString(ret, (boolean)true));
                System.out.println(" =============");
            }
            Staking.notifyLock();
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
    }

    public static void testLedger() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        ready.then(api -> {
            System.out.println("=========start testLedger=========");
            Types.QueryableStorage query = api.query();
            ISection staking = query.section("staking");
            Types.QueryableStorageFunction ledger = (Types.QueryableStorageFunction)staking.function("ledger");
            return Promise.all((Promise[])new Promise[]{(Promise)ledger.call(controller)});
        }).then(result -> {
            for (Object ret : result) {
                System.out.println("ledger : " + ret);
                System.out.println("ledger : " + ret.getClass());
                System.out.println("ledger :\n " + JSON.toJSONString(ret, (boolean)true));
                System.out.println(" =============");
            }
            Staking.notifyLock();
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
    }

    public static void testBonded() {
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        ready.then(api -> {
            System.out.println("=========start testBonded=========");
            Types.QueryableStorage query = api.query();
            ISection staking = query.section("staking");
            Types.QueryableStorageFunction bonded = (Types.QueryableStorageFunction)staking.function("bonded");
            return Promise.all((Promise[])new Promise[]{(Promise)bonded.call(controller)});
        }).then(result -> {
            for (Object ret : result) {
                System.out.println("bonded : " + ret);
                System.out.println("bonded : " + ret.getClass());
                System.out.println("bonded :\n " + JSON.toJSONString(ret, (boolean)true));
                System.out.println(" =============");
            }
            Staking.notifyLock();
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
    }
}

