/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.promise;

import com.onehilltech.promises.Promise;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.direct.ISection;
import org.polkadot.rpc.provider.ws.WsProvider;

public class E03_ListenToBalanceChange {
    static String Alice = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) {
        E03_ListenToBalanceChange.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        ready.then(api -> {
            Types.QueryableStorage query = api.query();
            ISection balances = query.section("balances");
            Types.QueryableStorageFunction freeBalance = (Types.QueryableStorageFunction)balances.function("freeBalance");
            return (Promise)freeBalance.call(Alice, o -> System.out.println("freeBalance result " + o));
        }).then(result -> {
            if (result instanceof IRpcFunction.Unsubscribe) {
                System.out.println(" set unsubscribe " + result);
                return null;
            }
            System.out.println("freeBalance result " + result);
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

