/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.promise;

import com.onehilltech.promises.Promise;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.common.keyring.Types;
import org.polkadot.direct.ISection;
import org.polkadot.example.TestingPairs;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.Types;
import org.polkadot.types.rpc.ExtrinsicStatus;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.EventRecord;
import org.polkadot.utils.UtilsCrypto;

public class E09_TransferEvents {
    static String ALICE = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static int AMOUNT = 10000;
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        E09_TransferEvents.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        String BOB = "5FHneW46xGXgs5mUiveU4sbTyGBzmstUspZC92UhjJM694ty";
        AtomicReference keyring = new AtomicReference();
        AtomicReference apiRef = new AtomicReference();
        ready.then(api -> {
            apiRef.set(api);
            keyring.set(TestingPairs.testKeyring());
            ISection system = api.query().section("system");
            return (Promise)((Types.QueryableStorageFunction)system.function("accountNonce")).call(ALICE);
        }).then(nonce -> {
            Types.KeyringPair alicePair = ((Types.KeyringInstance)keyring.get()).getPair(ALICE);
            String recipient = ((Types.KeyringInstance)keyring.get()).addFromSeed(UtilsCrypto.randomAsU8a(32), null, null).address();
            System.out.println("Sending " + AMOUNT + " from " + alicePair.address() + " to " + recipient + " with nonce " + nonce.toString());
            Types.SubmittableExtrinsicFunction transfer = (Types.SubmittableExtrinsicFunction)((ApiPromise)apiRef.get()).tx().section("balances").function("transfer");
            Types.IExtrinsic sign = transfer.call(recipient, AMOUNT).sign(alicePair, new Types.SignatureOptions().setNonce(nonce));
            SubmittableExtrinsic sign1 = (SubmittableExtrinsic)sign;
            return (Promise)sign1.send(new SubmittableExtrinsic.StatusCb(){

                @Override
                public Object callback(SubmittableExtrinsic.SubmittableResult result) {
                    ExtrinsicStatus status = result.getStatus();
                    List<EventRecord> events = result.getEvents();
                    System.out.println("Transaction status:" + status.getType());
                    if (status.isFinalized()) {
                        System.out.println("Completed at block hash" + status.asFinalized().toHex());
                        System.out.println("Events");
                        for (EventRecord event : events) {
                            EventRecord.Phase phase = event.getPhase();
                            Event eventEvent = event.getEvent();
                            System.out.println("\t" + phase.toString() + ": " + eventEvent.getSection() + "." + eventEvent.getMethod() + " " + eventEvent.getData().toString());
                        }
                        System.exit(0);
                    }
                    return null;
                }
            });
        }).then(result -> {
            System.out.println("result : " + result);
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    static {
        System.loadLibrary("jni");
        System.out.println("load ");
    }
}

