/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.promise;

import com.onehilltech.promises.Promise;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.common.keyring.Types;
import org.polkadot.example.TestingPairs;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.rpc.ExtrinsicStatus;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.EventRecord;
import org.polkadot.utils.Utils;

public class E10_UpgradeChain {
    static String ALICE = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static int AMOUNT = 10000;
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        E10_UpgradeChain.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        AtomicReference keyringRef = new AtomicReference();
        AtomicReference apiRef = new AtomicReference();
        ready.then(api -> {
            apiRef.set(api);
            System.out.println("============ start ==============");
            Types.QueryableStorageFunction key = (Types.QueryableStorageFunction)api.query().section("sudo").function("key");
            return (Promise)key.call(new Object[0]);
        }).then(adminId -> {
            System.out.println("adminId : " + adminId);
            Types.KeyringInstance keyring = TestingPairs.testKeyring();
            keyringRef.set(keyring);
            Types.KeyringPair adminPair = keyring.getPair(adminId.toString());
            byte[] bytes = Files.readAllBytes(Paths.get("test.wasm", new String[0]));
            String code = Utils.u8aToHex(bytes);
            Types.SubmittableExtrinsicFunction setCode = (Types.SubmittableExtrinsicFunction)((ApiPromise)apiRef.get()).tx().section("consensus").function("setCode");
            SubmittableExtrinsic proposal = setCode.call(code);
            System.out.println("Upgrading from " + adminId + ", " + code.length() / 2 + " bytes");
            Types.SubmittableModuleExtrinsics sudoSection = ((ApiPromise)apiRef.get()).tx().section("sudo");
            Types.SubmittableExtrinsicFunction sudoFunc = (Types.SubmittableExtrinsicFunction)sudoSection.function("sudo");
            SubmittableExtrinsic call = sudoFunc.call(proposal);
            return (Promise)call.signAndSendCb(adminPair, new SubmittableExtrinsic.StatusCb(){

                @Override
                public Object callback(SubmittableExtrinsic.SubmittableResult result) {
                    ExtrinsicStatus status = result.getStatus();
                    System.out.println("Proposal status:" + status.getType());
                    if (status.isFinalized()) {
                        System.out.println("You have just upgraded your chain");
                        System.out.println("Completed at block hash" + status.asFinalized().toHex());
                        System.out.println("Events:");
                        for (EventRecord event : result.getEvents()) {
                            Event eventEvent = event.getEvent();
                            System.out.println("\t" + event.getPhase().toString() + ": " + eventEvent.getSection() + "." + eventEvent.getMethod() + " " + eventEvent.getData().toString());
                        }
                        System.exit(0);
                    }
                    return null;
                }
            });
        }).then(result -> {
            System.out.println(" result " + result);
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    static void readFile() throws IOException {
        System.out.println(new String(Files.readAllBytes(Paths.get("test.wasm", new String[0]))));
    }

    static {
        System.loadLibrary("jni");
        System.out.println("load ");
    }
}

