/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.rx;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.List;
import org.polkadot.api.Types;
import org.polkadot.api.rx.ApiRx;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.Codec;
import org.polkadot.types.codec.CreateType;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.EventRecord;

public class E08_SystemEvent {
    static String Alice = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        E08_SystemEvent.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        Observable<ApiRx> apiRxObservable = ApiRx.create(wsProvider);
        apiRxObservable.flatMap(apiRx -> (ObservableSource)((Types.QueryableStorageFunction)apiRx.query().section("system").function("events")).call(new Object[0])).subscribe(events -> {
            List list = (List)events;
            Vector eventRecords = (Vector)list.get(0);
            System.out.println("events  " + eventRecords.size());
            for (EventRecord eventRecord : eventRecords) {
                EventRecord.Phase phase = eventRecord.getPhase();
                Event event = eventRecord.getEvent();
                List<CreateType.TypeDef> types = event.getTypeDef();
                System.out.println("\t" + event.getSection() + ":" + event.getMethod() + ":: (phase=" + phase.toString() + ")");
                System.out.println("\t\t" + event.getMeta().getDocumentation().toString());
                for (int index = 0; index < event.getData().size(); ++index) {
                    Codec data = (Codec)event.getData().get(index);
                    System.out.println("\t\t\t" + types.get(index).getType() + ": " + data.toString());
                }
            }
        });
    }
}

