/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.rx;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.List;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.Types;
import org.polkadot.api.rx.ApiRx;
import org.polkadot.common.keyring.Types;
import org.polkadot.example.TestingPairs;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.rpc.ExtrinsicStatus;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.EventRecord;
import org.polkadot.utils.UtilsCrypto;

public class E09_TransferEvents {
    static String ALICE = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static int AMOUNT = 10000;
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        E09_TransferEvents.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        String BOB = "5FHneW46xGXgs5mUiveU4sbTyGBzmstUspZC92UhjJM694ty";
        Observable<ApiRx> apiRxObservable = ApiRx.create(wsProvider);
        Types.KeyringInstance keyring = TestingPairs.testKeyring();
        Types.KeyringPair alicePair = keyring.getPair(ALICE);
        String recipient = keyring.addFromSeed(UtilsCrypto.randomAsU8a(32), null, null).address();
        apiRxObservable.flatMap(apiRx -> {
            SubmittableExtrinsic call = ((Types.SubmittableExtrinsicFunction)apiRx.tx().section("balances").function("transfer")).call(recipient, AMOUNT);
            return (ObservableSource)call.signAndSendCb(alicePair, null);
        }).subscribe(result -> {
            SubmittableExtrinsic.SubmittableResult submittableResult = (SubmittableExtrinsic.SubmittableResult)result;
            ExtrinsicStatus status = submittableResult.getStatus();
            List<EventRecord> events = submittableResult.getEvents();
            System.out.println("Transaction status:" + status.getType());
            if (status.isFinalized()) {
                System.out.println("Completed at block hash" + status.asFinalized().toHex());
                System.out.println("Events");
                for (EventRecord event : events) {
                    EventRecord.Phase phase = event.getPhase();
                    Event eventEvent = event.getEvent();
                    System.out.println("\t" + phase.toString() + ": " + eventEvent.getSection() + "." + eventEvent.getMethod() + " " + eventEvent.getData().toString());
                }
                System.exit(0);
            }
        });
    }

    static {
        System.loadLibrary("jni");
        System.out.println("load ");
    }
}

