/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.rpc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.direct.IRpcModule;
import org.polkadot.rpc.core.IRpc;
import org.polkadot.rpc.json.JsonRpc;
import org.polkadot.rpc.json.types.JsonRpcMethod;
import org.polkadot.rpc.json.types.JsonRpcSection;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.CreateType;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.StorageKey;
import org.polkadot.types.rpc.StorageChangeSet;
import org.polkadot.types.type.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCore
implements IRpcModule {
    private static final Logger logger = LoggerFactory.getLogger(RpcCore.class);
    IProvider provider;
    IRpc.RpcInterfaceSection author;
    IRpc.RpcInterfaceSection chain;
    IRpc.RpcInterfaceSection state;
    IRpc.RpcInterfaceSection system;
    Map<String, IRpc.RpcInterfaceSection> sectionMap = new HashMap<String, IRpc.RpcInterfaceSection>();

    @Override
    public IRpc.RpcInterfaceSection author() {
        return this.author;
    }

    @Override
    public IRpc.RpcInterfaceSection chain() {
        return this.chain;
    }

    @Override
    public IRpc.RpcInterfaceSection state() {
        return this.state;
    }

    @Override
    public IRpc.RpcInterfaceSection system() {
        return this.system;
    }

    public RpcCore() {
        this(new WsProvider());
    }

    public RpcCore(IProvider provider) {
        this.provider = provider;
        this.author = this.createRpcSection(JsonRpc.author);
        this.chain = this.createRpcSection(JsonRpc.chain);
        this.state = this.createRpcSection(JsonRpc.state);
        this.system = this.createRpcSection(JsonRpc.system);
    }

    public IRpc.RpcInterfaceSection createRpcSection(JsonRpcSection jsonRpcSection) {
        IRpc.RpcInterfaceSection ret = new IRpc.RpcInterfaceSection();
        Map<String, JsonRpcMethod> rpcMethods = jsonRpcSection.rpcMethods;
        for (JsonRpcMethod jsonRpcMethod : rpcMethods.values()) {
            if (jsonRpcMethod.isSubscription()) {
                ret.addFunction(jsonRpcMethod.getMethod(), this.createMethodSubscribe(jsonRpcMethod));
                continue;
            }
            ret.addFunction(jsonRpcMethod.getMethod(), this.createMethodSend(jsonRpcMethod));
        }
        return ret;
    }

    static String signature(JsonRpcMethod jsonRpcMethod) {
        String input = String.join((CharSequence)", ", jsonRpcMethod.getParams().stream().map(param -> param.getName() + ":" + param.getType()).collect(Collectors.toList()).toArray(new String[0]));
        return jsonRpcMethod.getMethod() + "(" + input + ")" + jsonRpcMethod.getType();
    }

    public IRpcFunction createMethodSend(final JsonRpcMethod jsonRpcMethod) {
        final String rpcName = String.format("%s_%s", jsonRpcMethod.getSection(), jsonRpcMethod.getMethod());
        IRpcFunction call = new IRpcFunction(){

            public Promise invoke(Object ... values) {
                try {
                    List params = RpcCore.this.formatInputs(jsonRpcMethod, Lists.newArrayList((Object[])values));
                    List<Object> paramsJson = params.stream().map(Codec::toJson).collect(Collectors.toList());
                    return RpcCore.this.provider.send(rpcName, paramsJson, null).then(result -> {
                        Object output = RpcCore.this.formatOutput(jsonRpcMethod, params, result);
                        return Promise.value((Object)output);
                    })._catch(err -> {
                        err.printStackTrace();
                        return null;
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String msg = String.format("%s:: %s", RpcCore.signature(jsonRpcMethod), e.getMessage());
                    logger.error(msg);
                    throw new RuntimeException(msg, e);
                }
            }
        };
        return call;
    }

    private List<Codec> formatInputs(JsonRpcMethod jsonRpcMethod, List<Object> inputs) {
        String optText;
        long reqArgCount = jsonRpcMethod.getParams().stream().filter(p -> !p.isOptional()).count();
        String string = optText = reqArgCount == (long)jsonRpcMethod.getParams().size() ? "" : "(" + ((long)jsonRpcMethod.getParams().size() - reqArgCount) + " optional)";
        assert ((long)inputs.size() >= reqArgCount && inputs.size() <= jsonRpcMethod.getParams().size()) : "Expected " + jsonRpcMethod.getParams().size() + " parameters" + optText + ", " + inputs + " found instead";
        ArrayList<Codec> ret = new ArrayList<Codec>();
        for (int i = 0; i < inputs.size(); ++i) {
            Codec type = CreateType.createType(jsonRpcMethod.getParams().get(i).getType(), inputs.get(i));
            ret.add(type);
        }
        return ret;
    }

    private Object formatOutput(JsonRpcMethod jsonRpcMethod, List<Codec> params, Object result) {
        if (result instanceof String) {
            String json = ((String)result).trim();
            if (json.startsWith("{")) {
                try {
                    JSONObject jsonObject = JSON.parseObject((String)((String)result));
                    result = jsonObject;
                }
                catch (Exception jsonObject) {}
            } else if (json.startsWith("[")) {
                try {
                    JSONArray jsonArray = JSON.parseArray((String)((String)result));
                    result = jsonArray;
                }
                catch (Exception jsonArray) {
                    // empty catch block
                }
            }
        }
        Codec base = CreateType.createType(jsonRpcMethod.getType(), result);
        if (jsonRpcMethod.getType().equals("StorageData")) {
            StorageKey key = (StorageKey)params.get(0);
            String type = key.getOutputType();
            if (StringUtils.isEmpty((CharSequence)type)) {
                type = "Data";
            }
            Types.ConstructorCodec clazz = CreateType.createClass(type);
            Modules.StorageFunctionMetadata meta = key.getMeta();
            if (key.getMeta() != null && key.getMeta().getType().isMap() && key.getMeta().getType().asMap().isLinked()) {
                return clazz.newInstance(base);
            }
            if (meta == null || meta.getModifier().isOptional()) {
                return new Option(clazz, result == null ? null : clazz.newInstance(base));
            }
            return clazz.newInstance(base);
        }
        if (jsonRpcMethod.getType().equals("StorageChangeSet")) {
            ArrayList ret = Lists.newArrayList();
            Vector keys = (Vector)params.get(0);
            for (StorageKey key : keys) {
                String type = key.getOutputType();
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "Data";
                }
                Types.ConstructorCodec clazz = CreateType.createClass(type);
                String hexKey = key.toHex();
                KeyValue.KeyValueOption option = ((StorageChangeSet)base).getChanges().stream().filter(item -> item.getKey().toHex().equals(hexKey)).findFirst().orElse(null);
                Modules.StorageFunctionMetadata meta = key.getMeta();
                if (option == null) {
                    ret.add(null);
                    continue;
                }
                if (key.getMeta() != null && key.getMeta().getType().isMap() && key.getMeta().getType().asMap().isLinked()) {
                    ret.add(clazz.newInstance(option.getValue().unwrapOr(null)));
                    continue;
                }
                if (meta == null || meta.getModifier().isOptional()) {
                    ret.add(new Option(clazz, option.getValue().isNone() ? null : clazz.newInstance(option.getValue().unwrap())));
                    continue;
                }
                ret.add(clazz.newInstance(option.getValue().unwrapOr(meta.getDefault())));
            }
            return ret;
        }
        return base;
    }

    public IRpcFunction createMethodSubscribe(final JsonRpcMethod jsonRpcMethod) {
        String updateType = jsonRpcMethod.getPubsub()[0];
        String subMethod = jsonRpcMethod.getPubsub()[1];
        String unsubMethod = jsonRpcMethod.getPubsub()[2];
        final String subName = jsonRpcMethod.getSection() + "_" + subMethod;
        final String unsubName = jsonRpcMethod.getSection() + "_" + unsubMethod;
        final String subType = jsonRpcMethod.getSection() + "_" + updateType;
        IRpcFunction ret = new IRpcFunction(){

            public Promise invoke(Object ... _values) {
                try {
                    Object o;
                    ArrayList values = Lists.newArrayList((Object[])_values);
                    IRpcFunction.SubscribeCallback cb = null;
                    if (CollectionUtils.isNotEmpty((Collection)values) && (o = values.get(values.size() - 1)) instanceof IRpcFunction.SubscribeCallback) {
                        Object remove = values.remove(values.size() - 1);
                        cb = (IRpcFunction.SubscribeCallback)remove;
                    }
                    List params = RpcCore.this.formatInputs(jsonRpcMethod, values);
                    List<Object> paramsJson = params.stream().map(Codec::toJson).collect(Collectors.toList());
                    if (cb != null) {
                        IRpcFunction.SubscribeCallback finalCb = cb;
                        IProvider.CallbackHandler<Object, Object> update = (error, result) -> {
                            if (error != null) {
                                logger.error("{}::{}", (Object)RpcCore.signature(jsonRpcMethod), error);
                                return;
                            }
                            finalCb.callback(RpcCore.this.formatOutput(jsonRpcMethod, params, result));
                        };
                        Promise<String> subscribe = RpcCore.this.provider.subscribe(subType, subName, paramsJson, update);
                        return subscribe.then(subscriptionId -> {
                            logger.debug(" subscriptionId = {}", subscriptionId);
                            return Promise.value(() -> RpcCore.this.provider.unsubscribe(subType, unsubName, Integer.parseInt(subscriptionId)));
                        })._catch(err -> {
                            logger.error(" promise error ", err);
                            return Promise.value((Object)err);
                        });
                    }
                    AtomicReference subscribe = new AtomicReference();
                    return new Promise(handler -> {
                        try {
                            IProvider.CallbackHandler<Exception, Object> callback = (err, result) -> {
                                if (err != null) {
                                    handler.reject((Throwable)err);
                                } else {
                                    Object output = RpcCore.this.formatOutput(jsonRpcMethod, params, result);
                                    handler.resolve(output);
                                }
                            };
                            subscribe.set(RpcCore.this.provider.subscribe(subType, subName, paramsJson, callback));
                        }
                        catch (Exception e1) {
                            handler.reject((Throwable)e1);
                        }
                    }).then(result -> {
                        ((Promise)subscribe.get()).then(subscribeId -> {
                            logger.info(" auto unsubscribe {}, {},{}", new Object[]{subType, unsubName, subscribeId});
                            return RpcCore.this.provider.unsubscribe(subType, unsubName, Integer.parseInt(subscribeId));
                        });
                        return Promise.value((Object)result);
                    });
                }
                catch (Exception e) {
                    logger.error(" " + RpcCore.signature(jsonRpcMethod), (Throwable)e);
                    throw e;
                }
            }

            @Override
            public boolean isSubscribe() {
                return true;
            }

            @Override
            public Promise unsubscribe(int subscriptionId) {
                return RpcCore.this.provider.unsubscribe(subType, unsubName, subscriptionId);
            }
        };
        return ret;
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public void disconnect() {
        this.provider.disconnect();
    }
}

