/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.rpc.provider.coder;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.polkadot.rpc.provider.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCoder {
    private static final Logger logger = LoggerFactory.getLogger(RpcCoder.class);
    private AtomicInteger id = new AtomicInteger(0);

    public Object decodeResponse(Types.JsonRpcResponse response) {
        assert (response != null) : "Empty response object received";
        assert ("2.0".equals(response.getJsonrpc())) : "Invalid jsonrpc field in decoded object";
        boolean isSubscription = response.getParams() != null && response.getMethod() != null;
        this.checkError(response.getError());
        assert (response.getResult() != null || isSubscription) : "No result found in JsonRpc response";
        if (isSubscription) {
            this.checkError(response.getParams().getError());
            return response.getParams().getResult();
        }
        return response.getResult();
    }

    public String encodeJson(String method, List<Object> params) {
        return JSON.toJSONString((Object)this.encodeObject(method, params));
    }

    public Types.JsonRpcRequest encodeObject(String method, List<Object> params) {
        return new Types.JsonRpcRequest(this.id.incrementAndGet(), "2.0", method, params);
    }

    public int getId() {
        return this.id.get();
    }

    private void checkError(Types.JsonRpcError error) {
        if (error != null) {
            String data = error.getData() == null ? "" : "(" + error.getData().substring(0, Math.min(10, error.getData().length())) + ")";
            String msg = String.format("%d : %s%s", error.getCode(), error.getMessage(), data);
            logger.error("{}", (Object)msg);
            throw new RuntimeException(msg);
        }
    }
}

