/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.rpc.provider.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.onehilltech.promises.Promise;
import java.util.List;
import org.polkadot.common.EventEmitter;
import org.polkadot.common.HttpClient;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.rpc.provider.Types;
import org.polkadot.rpc.provider.coder.RpcCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProvider
implements IProvider {
    private static final Logger logger = LoggerFactory.getLogger(HttpProvider.class);
    static final String ERROR_SUBSCRIBE = "HTTP Provider does not have subscriptions, use WebSockets instead";
    private RpcCoder coder = new RpcCoder();
    private String endpoint;

    public HttpProvider(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public boolean isHasSubscriptions() {
        return false;
    }

    @Override
    public IProvider clone() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void on(IProvider.ProviderInterfaceEmitted emitted, EventEmitter.EventListener cb) {
        logger.error("HTTP Provider does not have 'on' emitters, use WebSockets instead");
    }

    @Override
    public Promise<String> send(String method, List<Object> params, IProvider.SubscriptionHandler subscriptionHandler) {
        return new Promise(handler -> {
            try {
                Types.JsonRpcRequest jsonRpcRequest = this.coder.encodeObject(method, params);
                String body = JSON.toJSONString((Object)jsonRpcRequest);
                HttpClient.HeadOptions options = HttpClient.HeadOptions.build().setContentType("application/json").setHeader("Accept", "application/json").setHeader("Content-Length", body.length() + "");
                HttpClient.HttpResp response = HttpClient.post(this.endpoint, body, options);
                assert (response.getStatus() == 200) : "[" + response.getStatus() + "]: " + response.getBody();
                Types.JsonRpcResponse jsonRpcResponse = (Types.JsonRpcResponse)JSONObject.parseObject((String)response.getBody(), Types.JsonRpcResponse.class);
                Object result = this.coder.decodeResponse(jsonRpcResponse);
                handler.resolve(result);
            }
            catch (Exception e1) {
                handler.reject((Throwable)e1);
            }
        });
    }

    @Override
    public Promise<String> subscribe(String type, String method, List<Object> params, IProvider.CallbackHandler cb) {
        logger.error(ERROR_SUBSCRIBE);
        throw new UnsupportedOperationException(ERROR_SUBSCRIBE);
    }

    @Override
    public Promise<String> unsubscribe(String type, String method, int id) {
        logger.error(ERROR_SUBSCRIBE);
        throw new UnsupportedOperationException(ERROR_SUBSCRIBE);
    }
}

