/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.rpc.provider.ws;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.polkadot.common.EventEmitter;
import org.polkadot.common.ExecutorsManager;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.rpc.provider.IWsProvider;
import org.polkadot.rpc.provider.Types;
import org.polkadot.rpc.provider.coder.RpcCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsProvider
implements IWsProvider {
    private static final Map<String, String> ALIASSES = new HashMap<String, String>();
    private static final Logger logger;
    private boolean isConnected;
    private boolean autoConnect;
    private EventEmitter eventemitter = new EventEmitter();
    private RpcCoder coder = new RpcCoder();
    private String endpoint;
    private Map<Integer, WsStateAwaiting> handlers = new ConcurrentHashMap<Integer, WsStateAwaiting>();
    private LinkedList<String> queued = new LinkedList();
    private Map<String, WsStateSubscription> subscriptions = new ConcurrentHashMap<String, WsStateSubscription>();
    private Map<String, Types.JsonRpcResponse> waitingForId = new ConcurrentHashMap<String, Types.JsonRpcResponse>();
    private WebSocketClient webSocket;

    public WsProvider() {
        this("ws://127.0.0.1:9944", true);
    }

    public WsProvider(String endpoint) {
        this(endpoint, true);
    }

    public WsProvider(String endpoint, boolean autoConnect) {
        if (Pattern.matches("^(wss|ws):\\/\\/", endpoint)) {
            throw new RuntimeException("Endpoint should start with 'ws://', received " + endpoint);
        }
        this.endpoint = endpoint;
        this.autoConnect = autoConnect;
        if (autoConnect) {
            this.connect();
        }
    }

    @Override
    public void connect() {
        try {
            this.webSocket = new WebSocketClient(new URI(this.endpoint)){
                WsProvider wsProvider;
                {
                    this.wsProvider = WsProvider.this;
                }

                public void onOpen(ServerHandshake handshakedata) {
                    logger.info("WebSocket onOpen: {}", (Object)this.getURI());
                    this.wsProvider.isConnected = true;
                    this.wsProvider.emit(IProvider.ProviderInterfaceEmitted.connected, new Object[0]);
                    this.wsProvider.sendQueue();
                    this.wsProvider.resubscribe();
                }

                public void onMessage(String message) {
                    logger.debug("WebSocket onMessage:{}", (Object)message);
                    Types.JsonRpcResponse response = (Types.JsonRpcResponse)JSONObject.parseObject((String)message, Types.JsonRpcResponse.class);
                    if (StringUtils.isEmpty((CharSequence)response.getMethod())) {
                        this.wsProvider.onSocketMessageResult(response);
                    } else {
                        this.wsProvider.onSocketMessageSubscribe(response);
                    }
                }

                public void onClose(int code, String reason, boolean remote) {
                    if (this.wsProvider.autoConnect) {
                        logger.error("disconnected from ${} code: '${}' reason: '${}'", new Object[]{this.getURI(), code, reason});
                    }
                    this.wsProvider.isConnected = false;
                    this.wsProvider.emit(IProvider.ProviderInterfaceEmitted.disconnected, new Object[0]);
                    if (this.wsProvider.autoConnect) {
                        ExecutorsManager.schedule(() -> this.wsProvider.connect(), 1000L, TimeUnit.MILLISECONDS);
                    }
                }

                public void onError(Exception ex) {
                    logger.error(" socket error ", (Throwable)ex);
                    this.wsProvider.emit(IProvider.ProviderInterfaceEmitted.error, new Object[]{ex});
                }
            };
            this.webSocket.connect();
        }
        catch (Exception e) {
            logger.error("connect error", (Throwable)e);
        }
    }

    private void emit(EventEmitter.EventType type, Object ... args) {
        this.eventemitter.emit(type, args);
    }

    private void onSocketMessageSubscribe(Types.JsonRpcResponse response) {
        String method = ALIASSES.get(response.getMethod());
        if (method == null) {
            method = response.getMethod();
        }
        String subId = method + "::" + response.getParams().getSubscription();
        logger.debug("handling: response =', {}, 'subscription =', {}", (Object)response, (Object)subId);
        WsStateSubscription handler = this.subscriptions.get(subId);
        if (handler == null) {
            this.waitingForId.put(subId, response);
            logger.info("Unable to find handler for subscription=${}", (Object)subId);
            return;
        }
        this.waitingForId.remove(subId);
        try {
            Object result = this.coder.decodeResponse(response);
            handler.getCallBack().callback(null, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            handler.getCallBack().callback(e, null);
        }
    }

    private void onSocketMessageResult(Types.JsonRpcResponse response) {
        logger.debug("handling response {}, {}", (Object)response, (Object)response.getId());
        WsStateAwaiting handler = this.handlers.get(response.getId());
        if (handler == null) {
            logger.error("Unable to find handler for id={}", (Object)response.getId());
            return;
        }
        try {
            Object result = this.coder.decodeResponse(response);
            handler.callBack.callback(null, result);
            IProvider.SubscriptionHandler subscription = handler.subscription;
            if (subscription != null) {
                String subId = subscription.getType() + "::" + result;
                this.subscriptions.put(subId, new WsStateSubscription(subscription.getCallBack(), subscription.getType(), handler.method, handler.params));
                if (this.waitingForId.containsKey(subId)) {
                    this.onSocketMessageSubscribe(this.waitingForId.get(subId));
                }
            }
        }
        catch (Exception e) {
            handler.callBack.callback(e, null);
        }
        this.handlers.remove(response.getId());
    }

    private void sendQueue() {
        while (this.queued.peek() != null) {
            String head = this.queued.poll();
            try {
                this.webSocket.send(head);
            }
            catch (Exception e) {
                logger.error(" sendQueue error {}", (Object)head, (Object)e);
            }
        }
    }

    @Override
    public Promise<String> send(String method, List<Object> params, IProvider.SubscriptionHandler subscription) {
        return new Promise(handler -> {
            try {
                Types.JsonRpcRequest jsonRpcRequest = this.coder.encodeObject(method, params);
                String json = JSON.toJSONString((Object)jsonRpcRequest);
                int id = jsonRpcRequest.getId();
                IProvider.CallbackHandler<Exception, Object> callback = (err, result) -> {
                    if (err != null) {
                        handler.reject((Throwable)err);
                    } else {
                        handler.resolve(result);
                    }
                };
                logger.debug("call {} {}, {}, {}, {}", new Object[]{id, method, params, json, subscription});
                this.handlers.put(id, new WsStateAwaiting<Object>(callback, method, params, subscription));
                if (this.isConnected() && this.webSocket != null) {
                    this.webSocket.send(json);
                } else {
                    this.queued.add(json);
                }
            }
            catch (Exception e1) {
                handler.reject((Throwable)e1);
            }
        });
    }

    private void resubscribe() {
        HashMap<String, WsStateSubscription> subscriptions = new HashMap<String, WsStateSubscription>(this.subscriptions);
        this.subscriptions.clear();
        for (WsStateSubscription subscription : subscriptions.values()) {
            if (subscription.getType().startsWith("author_")) continue;
            try {
                Promise<String> subscribe = this.subscribe(subscription.getType(), subscription.method, subscription.params, subscription.getCallBack());
                subscribe.then(subscribeId -> {
                    logger.info(" resubscribe {}", subscribeId);
                    return null;
                });
            }
            catch (Exception e) {
                logger.error("resubscribe error {}", (Object)subscription, (Object)e);
            }
        }
    }

    @Override
    public boolean isHasSubscriptions() {
        return true;
    }

    @Override
    public IProvider clone() {
        return new WsProvider(this.endpoint);
    }

    @Override
    public void disconnect() {
        if (this.webSocket == null) {
            throw new RuntimeException("Cannot disconnect on a non-open websocket");
        }
        this.autoConnect = false;
        this.webSocket.close(1000);
        this.webSocket = null;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public void on(IProvider.ProviderInterfaceEmitted emitted, EventEmitter.EventListener cb) {
        this.eventemitter.on(emitted, cb);
    }

    @Override
    public Promise<String> subscribe(String type, String method, List<Object> params, IProvider.CallbackHandler cb) {
        return this.send(method, params, new IProvider.SubscriptionHandler(cb, type));
    }

    @Override
    public Promise<String> unsubscribe(String type, String method, int id) {
        String subscription = type + "::" + id;
        if (this.subscriptions.get(subscription) == null) {
            logger.info("Unable to find active subscription={}", (Object)subscription);
            return Promise.reject((Throwable)new RuntimeException("Unable to find active subscription=" + subscription));
        }
        this.subscriptions.remove(subscription);
        return this.send(method, Lists.newArrayList((Object[])new Object[]{id}), null);
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public RpcCoder getCoder() {
        return this.coder;
    }

    public void setCoder(RpcCoder coder) {
        this.coder = coder;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Queue<String> getQueued() {
        return this.queued;
    }

    public void setQueued(LinkedList<String> queued) {
        this.queued = queued;
    }

    public Map<String, Types.JsonRpcResponse> getWaitingForId() {
        return this.waitingForId;
    }

    public void setWaitingForId(Map<String, Types.JsonRpcResponse> waitingForId) {
        this.waitingForId = waitingForId;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocketClient webSocket) {
        this.webSocket = webSocket;
    }

    static {
        ALIASSES.put("chain_finalisedHead", "chain_finalizedHead");
        logger = LoggerFactory.getLogger(WsProvider.class);
    }

    static class WsStateSubscription
    extends IProvider.SubscriptionHandler {
        String method;
        List<Object> params;

        public WsStateSubscription(String method, List<Object> params) {
            this.method = method;
            this.params = params;
        }

        public WsStateSubscription(IProvider.CallbackHandler<Object, Object> callBack, String type, String method, List<Object> params) {
            super(callBack, type);
            this.method = method;
            this.params = params;
        }
    }

    public static class WsStateAwaiting<T> {
        public IProvider.CallbackHandler<Throwable, T> callBack;
        public String method;
        public List<Object> params;
        public IProvider.SubscriptionHandler subscription;

        public WsStateAwaiting(IProvider.CallbackHandler<Throwable, T> callBack, String method, List<Object> params, IProvider.SubscriptionHandler subscription) {
            this.callBack = callBack;
            this.method = method;
            this.params = params;
            this.subscription = subscription;
        }
    }
}

