/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.rpc.rx;

import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import org.polkadot.common.EventEmitter;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.rpc.core.IRpc;
import org.polkadot.rpc.core.RpcCore;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.rpc.rx.Types;
import org.polkadot.utils.RxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcRx
extends Types.RpcRxInterface {
    private static final Logger logger = LoggerFactory.getLogger(RpcRx.class);
    private RpcCore api;
    private EventEmitter eventEmitter;
    private BehaviorSubject<Boolean> isConnected;

    public RpcRx(IProvider provider) {
        this(new RpcCore(provider));
    }

    public RpcRx(RpcCore rpc) {
        this.api = rpc;
        this.eventEmitter = new EventEmitter();
        this.isConnected = BehaviorSubject.createDefault((Object)this.api.getProvider().isConnected());
        this.initEmitters(this.api.getProvider());
        this.author = this.createInterface(this.api.author());
        this.chain = this.createInterface(this.api.chain());
        this.state = this.createInterface(this.api.state());
        this.system = this.createInterface(this.api.system());
    }

    private void initEmitters(IProvider provider) {
        provider.on(IProvider.ProviderInterfaceEmitted.connected, value -> {
            this.isConnected.onNext((Object)true);
            this.emit(IProvider.ProviderInterfaceEmitted.connected, new Object[0]);
        });
        provider.on(IProvider.ProviderInterfaceEmitted.disconnected, value -> {
            this.isConnected.onNext((Object)false);
            this.emit(IProvider.ProviderInterfaceEmitted.disconnected, new Object[0]);
        });
    }

    @Override
    public Observable<Boolean> isConnected() {
        return this.isConnected;
    }

    @Override
    void on(IProvider.ProviderInterfaceEmitted type, EventEmitter.EventListener handler) {
        this.eventEmitter.on(type, handler);
    }

    protected void emit(IProvider.ProviderInterfaceEmitted type, Object ... args) {
        this.eventEmitter.emit(type, args);
    }

    private Types.RpcRxInterfaceSection createInterface(IRpc.RpcInterfaceSection section) {
        Types.RpcRxInterfaceSection ret = new Types.RpcRxInterfaceSection();
        for (String functionName : section.functionNames()) {
            if (functionName.equals("subscribe") || functionName.equals("unsubscribe")) continue;
            ret.put(functionName, this.createObservable(functionName, section));
        }
        return ret;
    }

    private Types.RpcRxInterfaceMethod createObservable(final String name, final IRpc.RpcInterfaceSection section) {
        final IRpcFunction function = (IRpcFunction)section.function(name);
        if (function.isSubscribe()) {
            return new Types.RpcRxInterfaceMethod(){

                @Override
                public Observable<Object> call(Object ... params) {
                    return RpcRx.this.createReplayV2(name, section, params);
                }
            };
        }
        return new Types.RpcRxInterfaceMethod(){

            @Override
            public Observable<Object> call(Object ... params) {
                Promise invoke = function.invoke(params);
                return RxUtils.fromPromise(invoke);
            }
        };
    }

    private Observable createReplayV2(String name, IRpc.RpcInterfaceSection section, Object ... params) {
        IRpcFunction function = (IRpcFunction)section.function(name);
        final PublishSubject subject = PublishSubject.create();
        IRpcFunction.SubscribeCallback replayCallBack = new IRpcFunction.SubscribeCallback(){

            public void callback(Object o) {
                subject.onNext(o);
            }
        };
        ArrayList args = Lists.newArrayList((Object[])params);
        args.add(replayCallBack);
        final Promise subscribe = function.invoke(args.toArray(new Object[0]))._catch(error -> {
            subject.onError(error);
            return null;
        });
        Observable ret = subject.doOnDispose(new Action(){

            public void run() throws Exception {
                subscribe.then(result -> {
                    IRpcFunction.Unsubscribe unsubscribe = (IRpcFunction.Unsubscribe)result;
                    logger.debug(" doOnDispose unsub");
                    unsubscribe.unsubscribe();
                    return null;
                })._catch(err -> {
                    err.printStackTrace();
                    return null;
                });
            }
        });
        return ret.replay(1).refCount();
    }

    private Observable createReplay(final String name, final IRpc.RpcInterfaceSection section, final Object ... params) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> emitter) throws Exception {
                final IRpcFunction function = (IRpcFunction)section.function(name);
                IRpcFunction.SubscribeCallback replayCallBack = RpcRx.this.createReplayCallBack((ObservableEmitter<Object>)emitter);
                final Promise promise = function.invoke(params, replayCallBack)._catch(error -> {
                    emitter.onError(error);
                    return null;
                });
                emitter.setDisposable(new Disposable(){
                    boolean disposed;

                    public void dispose() {
                        if (this.disposed) {
                            return;
                        }
                        this.disposed = true;
                        promise.then(result -> function.unsubscribe((Integer)result))._catch(err -> {
                            err.printStackTrace();
                            return null;
                        });
                    }

                    public boolean isDisposed() {
                        return this.disposed;
                    }
                });
            }
        }).replay(1).refCount();
    }

    private IRpcFunction.SubscribeCallback createReplayCallBack(final ObservableEmitter<Object> emitter) {
        return new IRpcFunction.SubscribeCallback(){

            public void callback(Object o) {
                emitter.onNext(o);
            }
        };
    }
}

