/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.type.extrinsics;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.polkadot.type.extrinsics.CreateUnchecked;
import org.polkadot.type.extrinsics.Index;
import org.polkadot.types.metadata.v0.Calls;
import org.polkadot.types.metadata.v0.MetadataV0;
import org.polkadot.types.primitive.Method;
import org.polkadot.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromMetadata {
    private static final Logger logger = LoggerFactory.getLogger(FromMetadata.class);

    public static Method.ModulesWithMethods fromMetadata(MetadataV0 metadata) {
        AtomicInteger indexCount = new AtomicInteger(-1);
        Function<String, Integer> findIndex = prefix -> {
            indexCount.getAndIncrement();
            Calls.OuterDispatchCall mod = metadata.getCalls().stream().filter(item -> item.getPrefix().toString().equals(prefix)).findFirst().orElse(null);
            if (mod == null) {
                logger.error("Unable to find module index for {}", prefix);
                return indexCount.get();
            }
            return mod.getIndex().intValue();
        };
        metadata.getModules().stream().filter(meta -> meta.getModule().getCall() != null && meta.getModule().getCall().getFunctions().length() > 0).forEach(meta -> {
            String prefix = Utils.stringCamelCase(meta.getPrefix().toString());
            Integer index = (Integer)findIndex.apply(meta.getPrefix().toString());
            Method.Methods methods = new Method.Methods();
            meta.getModule().getCall().getFunctions().stream().forEach(funcMeta -> {
                String funcName = Utils.stringCamelCase(funcMeta.getName().toString());
                methods.put(funcName, CreateUnchecked.createDescriptor(prefix, funcName, index, funcMeta));
            });
            Index.extrinsics.put(prefix, methods);
        });
        return Index.extrinsics;
    }
}

