/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.type.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.polkadot.type.storage.CreateFunction;
import org.polkadot.type.storage.Substrate;
import org.polkadot.type.storage.Types;
import org.polkadot.types.metadata.v0.MetadataV0;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Text;
import org.polkadot.utils.Utils;

public class FromMetadata {
    public static Types.Storage fromMetadata(MetadataV0 metadata) {
        final HashMap<String, Types.ModuleStorage> storageModules = new HashMap<String, Types.ModuleStorage>();
        for (Modules.RuntimeModuleMetadata moduleMetadata : metadata.getModules()) {
            if (moduleMetadata.getStorage().isNone()) continue;
            Modules.StorageMetadata storageMetadata = moduleMetadata.getStorage().unwrap();
            Text prefix = storageMetadata.getPrefix();
            Types.ModuleStorage newModule = new Types.ModuleStorage();
            for (Modules.StorageFunctionMetadata func : storageMetadata.getFunctions()) {
                newModule.addFunction(Utils.stringLowerFirst(func.getName().toString()), CreateFunction.createFunction(prefix.toString(), func.getName().toString(), func, false, null));
            }
            storageModules.put(Utils.stringLowerFirst(prefix.toString()), newModule);
        }
        return new Types.Storage(){
            Map<String, Types.ModuleStorage> modules;
            {
                this.modules = storageModules;
            }

            @Override
            public Types.ModuleStorage section(String section) {
                return this.modules.get(section);
            }

            @Override
            public Set<String> sectionNames() {
                return this.modules.keySet();
            }

            @Override
            public Types.ModuleStorage substrate() {
                return Substrate.substrate;
            }
        };
    }
}

