/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.type.storage;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.polkadot.type.storage.CreateFunction;
import org.polkadot.type.storage.Types;
import org.polkadot.types.Codec;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.StorageKey;
import org.polkadot.types.primitive.Text;

public class Substrate {
    public static Map<String, StorageKey.StorageFunction> allFunctions = new HashMap<String, StorageKey.StorageFunction>();
    public static StorageKey.StorageFunction code = Substrate.createRuntimeFunction("code", ":code", new SubstrateMetadata("Wasm code of the runtime.", "Bytes"));
    public static StorageKey.StorageFunction heapPages = Substrate.createRuntimeFunction("heapPages", ":heappages", new SubstrateMetadata("Number of wasm linear memory pages required for execution of the runtime.", "u64"));
    public static StorageKey.StorageFunction authorityCount = Substrate.createRuntimeFunction("authorityCount", ":auth:len", new SubstrateMetadata("Number of authorities.", "u32"));
    public static StorageKey.StorageFunction authorityPrefix = Substrate.createRuntimeFunction("authorityPrefix", ":auth:", new SubstrateMetadata("Prefix under which authorities are storied.", "u32"));
    public static StorageKey.StorageFunction extrinsicIndex = Substrate.createRuntimeFunction("extrinsicIndex", ":extrinsic_index", new SubstrateMetadata("Current extrinsic index (u32) is stored under this key.", "u32"));
    public static StorageKey.StorageFunction changesTrieConfig = Substrate.createRuntimeFunction("changesTrieConfig", ":changes_trie", new SubstrateMetadata("Changes trie configuration is stored under this key.", "u32"));
    public static Types.ModuleStorage substrate = new Types.ModuleStorage();

    static StorageKey.StorageFunction createRuntimeFunction(String method, final String key, SubstrateMetadata substrateMetadata) {
        LinkedHashMap<String, Codec> metaValues = new LinkedHashMap<String, Codec>();
        metaValues.put("documentation", new Vector<Text>(TypesUtils.getConstructorCodec(Text.class), Lists.newArrayList((Object[])new String[]{substrateMetadata.getDocumentation()})));
        metaValues.put("modifier", new Modules.StorageFunctionModifier((Object)1));
        metaValues.put("type", new Modules.StorageFunctionType(substrateMetadata.getType(), 0));
        metaValues.put("name", new Text("name"));
        metaValues.put("default", new Bytes(null));
        Modules.StorageFunctionMetadata storageFunctionMetadata = new Modules.StorageFunctionMetadata(metaValues){

            @Override
            public Object toJson() {
                return key;
            }
        };
        StorageKey.StorageFunction storageFunction = CreateFunction.createFunction("Substrate", method, storageFunctionMetadata, true, key);
        allFunctions.put(method, storageFunction);
        return storageFunction;
    }

    static {
        substrate.addFunction("code", code);
        substrate.addFunction("heapPages", heapPages);
        substrate.addFunction("authorityCount", authorityCount);
        substrate.addFunction("authorityPrefix", authorityPrefix);
        substrate.addFunction("extrinsicIndex", extrinsicIndex);
        substrate.addFunction("changesTrieConfig", changesTrieConfig);
    }

    public static class SubstrateMetadata {
        private String documentation;
        private String type;

        public SubstrateMetadata(String documentation, String type) {
            this.documentation = documentation;
            this.type = type;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public void setDocumentation(String documentation) {
            this.documentation = documentation;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

