/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.types.Codec;
import org.polkadot.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInt
extends BigInteger
implements Codec {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInt.class);
    private int bitLength;
    private boolean isHexJson;
    private boolean isNegative;

    public AbstractInt(boolean isNegative, Object value, int bitLength, boolean isHexJson) {
        super(AbstractInt.decodeAbstractInt(value, bitLength, isNegative));
        this.bitLength = bitLength;
        this.isHexJson = isHexJson;
        this.isNegative = isNegative;
    }

    static String decodeAbstractInt(Object value, int bitLength, boolean isNegative) {
        if (Utils.isHex(value)) {
            return Utils.hexToBn(value, false, isNegative).toString();
        }
        if (Utils.isU8a(value)) {
            try {
                byte[] subarray = ArrayUtils.subarray((byte[])Utils.u8aToU8a(value), (int)0, (int)(bitLength / 8));
                return Utils.u8aToBn(subarray, true, isNegative).toString();
            }
            catch (Exception e) {
                logger.error("AbstractInt value decoding failed {}", value, (Object)e);
                return "0";
            }
        }
        if (value instanceof String) {
            return new BigInteger((String)value, 10).toString();
        }
        return Utils.bnToBn(value).toString();
    }

    @Override
    public int getEncodedLength() {
        return this.bitLength / 8;
    }

    @Override
    public boolean isEmpty() {
        return this.equals(ZERO);
    }

    @Override
    public int bitLength() {
        return this.bitLength;
    }

    @Override
    public boolean eq(Object other) {
        BigInteger bigInteger = Utils.isHex(other) ? Utils.hexToBn(other, false, this.isNegative) : Utils.bnToBn(other);
        return super.equals(bigInteger);
    }

    public BigInteger toBn() {
        return this;
    }

    @Override
    public abstract String toHex();

    @Override
    public Object toJson() {
        return this.isHexJson ? this.toHex() : Integer.valueOf(this.intValue());
    }

    @Override
    public abstract byte[] toU8a(boolean var1);
}

