/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Compact;
import org.polkadot.types.codec.EnumType;
import org.polkadot.types.codec.Linkage;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Tuple;
import org.polkadot.types.codec.TypeRegistry;
import org.polkadot.types.codec.Vector;

public class CreateType {
    public static List<String> typeSplit(String type) {
        int sDepth = 0;
        int tDepth = 0;
        int vDepth = 0;
        int start = 0;
        ArrayList<String> result = new ArrayList<String>();
        block9: for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            switch (c) {
                case ',': {
                    if (sDepth != 0 || tDepth != 0 || vDepth != 0) continue block9;
                    result.add(type.substring(start, i - start).trim());
                    start = i + 1;
                    continue block9;
                }
                case '{': {
                    ++sDepth;
                    continue block9;
                }
                case '}': {
                    --sDepth;
                    continue block9;
                }
                case '(': {
                    ++tDepth;
                    continue block9;
                }
                case ')': {
                    --tDepth;
                    continue block9;
                }
                case '<': {
                    ++vDepth;
                    continue block9;
                }
                case '>': {
                    --vDepth;
                    continue block9;
                }
            }
        }
        result.add(type.substring(start, type.length()).trim());
        return result;
    }

    private static String startingWith(String type, String start, String end) {
        if (start.length() >= type.length() || end.length() >= type.length()) {
            return null;
        }
        if (!type.substring(0, start.length()).equals(start)) {
            return null;
        }
        assert (type.substring(type.length() - end.length()).equals(end)) : "Expected " + start + " closing with " + end;
        return type.substring(start.length(), type.length() - end.length());
    }

    public static TypeDef getTypeDef(String type) {
        return CreateType.getTypeDef(type, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeDef getTypeDef(String type, String name) {
        type = type.trim();
        TypeDef value = new TypeDef(TypeDefInfo.Plain, name, type, null);
        String subType = "";
        subType = CreateType.startingWith(type, "(", ")");
        if (subType != null) {
            value.info = TypeDefInfo.Tuple;
            value.sub = CreateType.typeSplit(subType).stream().map(inner -> CreateType.getTypeDef(inner, null)).collect(Collectors.toList());
            return value;
        } else {
            subType = CreateType.startingWith(type, "{", "}");
            if (subType != null) {
                JSONObject parsed = JSONObject.parseObject((String)type);
                Set keys = parsed.keySet();
                if (keys.size() == 1 && ((String)keys.stream().findFirst().get()).equals("_enum")) {
                    Object details = parsed.get((Object)"_enum");
                    value.info = TypeDefInfo.Enum;
                    if (details instanceof JSONArray) {
                        value.sub = ((JSONArray)details).stream().map(n -> new TypeDef(TypeDefInfo.Plain, name, "Null", null)).collect(Collectors.toList());
                        return value;
                    } else {
                        if (!(details instanceof JSONObject)) throw new UnsupportedOperationException("" + details.getClass());
                        value.sub = ((JSONObject)details).entrySet().stream().map(e -> {
                            String iType = (String)e.getValue();
                            if (StringUtils.isEmpty((CharSequence)iType)) {
                                iType = "Null";
                            }
                            return new TypeDef(TypeDefInfo.Plain, (String)e.getKey(), (String)e.getValue(), null);
                        }).collect(Collectors.toList());
                    }
                    return value;
                } else {
                    value.info = TypeDefInfo.Struct;
                    value.sub = keys.stream().map(n -> CreateType.getTypeDef(parsed.getString(n), n)).collect(Collectors.toList());
                }
                return value;
            } else {
                subType = CreateType.startingWith(type, "Compact<", ">");
                if (subType != null) {
                    value.info = TypeDefInfo.Compact;
                    value.sub = Lists.newArrayList((Object[])new TypeDef[]{CreateType.getTypeDef(subType, null)});
                    return value;
                } else {
                    subType = CreateType.startingWith(type, "Option<", ">");
                    if (subType != null) {
                        value.info = TypeDefInfo.Option;
                        value.sub = Lists.newArrayList((Object[])new TypeDef[]{CreateType.getTypeDef(subType, null)});
                        return value;
                    } else {
                        subType = CreateType.startingWith(type, "Vec<", ">");
                        if (subType != null) {
                            value.info = TypeDefInfo.Vector;
                            value.sub = Lists.newArrayList((Object[])new TypeDef[]{CreateType.getTypeDef(subType, null)});
                            return value;
                        } else {
                            subType = CreateType.startingWith(type, "Linkage<", ">");
                            if (subType == null) return value;
                            value.info = TypeDefInfo.Linkage;
                            value.sub = Lists.newArrayList((Object[])new TypeDef[]{CreateType.getTypeDef(subType, null)});
                        }
                    }
                }
            }
        }
        return value;
    }

    public static Types.ConstructorCodec getTypeClass(TypeDef value) {
        Types.ConstructorCodec type = TypeRegistry.getDefaultRegistry().get(value.type);
        if (type != null) {
            return type;
        }
        assert (CollectionUtils.isNotEmpty(value.sub)) : "Expected subtype for " + (Object)((Object)value.info);
        switch (value.info) {
            case Compact: {
                return Compact.with(CreateType.getTypeClass(value.sub.get(0)));
            }
            case Enum: {
                Types.ConstructorDef enumDefs = new Types.ConstructorDef();
                value.sub.forEach(def -> enumDefs.add(def.name, CreateType.getTypeClass(def)));
                return EnumType.with(enumDefs);
            }
            case Option: {
                return Option.with(CreateType.getTypeClass(value.sub.get(0)));
            }
            case Struct: {
                Types.ConstructorDef structDefs = new Types.ConstructorDef();
                value.sub.forEach(def -> structDefs.add(def.name, CreateType.getTypeClass(def)));
                return Struct.with(structDefs);
            }
            case Tuple: {
                Types.ConstructorDef tupleDef = new Types.ConstructorDef();
                value.sub.forEach(def -> tupleDef.add(def.name, CreateType.getTypeClass(def)));
                return Tuple.with(tupleDef);
            }
            case Vector: {
                return Vector.with(CreateType.getTypeClass(value.sub.get(0)));
            }
            case Linkage: {
                return Linkage.withKey(CreateType.getTypeClass(value.sub.get(0)));
            }
        }
        throw new UnsupportedOperationException("Unable to determine type from " + value.type);
    }

    public static Types.ConstructorCodec createClass(String type) {
        return CreateType.getTypeClass(CreateType.getTypeDef(type, null));
    }

    public static Codec createType(String type, Object value) {
        Types.ConstructorCodec typeClass = CreateType.createClass(type);
        return typeClass.newInstance(value);
    }

    public static class TypeDef {
        TypeDefInfo info;
        String name;
        String type;
        List<TypeDef> sub;

        public TypeDef(TypeDefInfo info, String name, String type, List<TypeDef> sub) {
            this.info = info;
            this.name = name;
            this.type = type;
            this.sub = sub;
        }

        public TypeDefInfo getInfo() {
            return this.info;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public List<TypeDef> getSub() {
            return this.sub;
        }
    }

    public static enum TypeDefInfo {
        Compact,
        Enum,
        Option,
        Plain,
        Struct,
        Tuple,
        Vector,
        Linkage;

    }
}

