/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import java.util.List;
import org.polkadot.types.Codec;
import org.polkadot.types.codec.Base;
import org.polkadot.utils.Utils;

public class Enum
extends Base<Number>
implements Codec {
    private List<String> enumList;

    public Enum(List<String> def, Object value) {
        super(Enum.decodeEnum(def, value));
        this.enumList = def;
    }

    private static Number decodeEnum(List<String> def, Object value) {
        if (value instanceof Enum) {
            return (Number)((Enum)value).raw;
        }
        if (Utils.isU8a(value)) {
            return ((byte[])value)[0];
        }
        if (value instanceof String) {
            return def.indexOf(value);
        }
        return (Number)value;
    }

    @Override
    public int getEncodedLength() {
        return 1;
    }

    public int getIndex() {
        return ((Number)this.raw).intValue();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean eq(Object other) {
        if (other instanceof Enum) {
            return ((Number)((Enum)other).raw).equals(this.raw);
        }
        if (other instanceof String) {
            return this.toString().equals(other);
        }
        return ((Number)this.raw).equals(other);
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a(false));
    }

    @Override
    public Object toJson() {
        return this.raw;
    }

    public int toNumber() {
        return ((Number)this.raw).intValue();
    }

    public String toString() {
        if (this.enumList.size() > ((Number)this.raw).intValue()) {
            return this.enumList.get(((Number)this.raw).intValue());
        }
        return ((Number)this.raw).toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return new byte[]{((Number)this.raw).byteValue()};
    }
}

