/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.google.common.primitives.UnsignedBytes;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.polkadot.types.Codec;
import org.polkadot.types.codec.Base;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Set
extends Base<List<String>>
implements Codec {
    private static final Logger logger = LoggerFactory.getLogger(Set.class);
    private SetValues setValues;

    public Set(SetValues setValues, Object value) {
        super(Set.decodeSet(setValues, value));
        this.setValues = setValues;
    }

    static List<String> decodeSet(SetValues setValues, Object value) {
        List<String> result;
        long computed;
        if (Utils.isU8a(value)) {
            byte[] bytes = Utils.u8aToU8a(value);
            return Set.decodeSet(setValues, bytes[0]);
        }
        if (value instanceof List || value.getClass().isArray()) {
            List<Object> list = CodecUtils.arrayLikeToList(value);
            List<String> result2 = list.stream().filter(v -> {
                if (setValues.containsKey(v)) {
                    return true;
                }
                logger.error("Ignoring invalid {} passed to Set", v);
                return false;
            }).map(v -> v.toString()).collect(Collectors.toList());
            return result2;
        }
        long longValue = ((Number)value).longValue();
        if (longValue != (computed = Set.encodeSet(setValues, result = setValues.keySet().stream().filter(k -> (longValue & (long)((Integer)setValues.get(k)).intValue()) == (long)((Integer)setValues.get(k)).intValue()).collect(Collectors.toList())))) {
            logger.error("Mismatch decoding {}, computed as {} with {}", new Object[]{value, computed, result});
        }
        return result;
    }

    static long encodeSet(SetValues setValues, List<String> value) {
        long result = 0L;
        for (String v : value) {
            result |= (long)(setValues.containsKey(v) ? (Integer)setValues.get(v) : 0);
        }
        return result;
    }

    @Override
    public int getEncodedLength() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.values().isEmpty();
    }

    public List<String> values() {
        return (List)this.raw;
    }

    public long valueEncoded() {
        return Set.encodeSet(this.setValues, (List)this.raw);
    }

    @Override
    public boolean eq(Object other) {
        if (other instanceof List || other.getClass().isArray()) {
            LinkedHashSet<String> set1 = new LinkedHashSet<String>(this.values());
            LinkedHashSet<Object> set2 = new LinkedHashSet<Object>(CodecUtils.arrayLikeToList(other));
            return CodecUtils.compareArray(set1.stream().collect(Collectors.toList()), set2.stream().collect(Collectors.toList()));
        }
        if (other instanceof Set) {
            return this.eq(((Set)other).values());
        }
        if (other instanceof Number) {
            return this.valueEncoded() == ((Number)other).longValue();
        }
        return false;
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a());
    }

    @Override
    public Object toJson() {
        return this.values();
    }

    public String toString() {
        return this.values().toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return new byte[]{UnsignedBytes.checkedCast((long)this.valueEncoded())};
    }

    public static class SetValues
    extends LinkedHashMap<String, Integer> {
        public SetValues(Map<String, Integer> map) {
            this.putAll(map);
        }
    }
}

