/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.polkadot.common.ReflectionUtils;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.types.primitive.Method;
import org.polkadot.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Struct
extends LinkedHashMap<String, Codec>
implements Codec {
    private static final Logger logger = LoggerFactory.getLogger(Method.class);
    Map<String, String> jsonMap;
    Types.ConstructorDef constructorDef;

    public Struct(Types.ConstructorDef constructorDef, Object value, Map<String, String> json) {
        Map<String, Codec> codecMap = Struct.decodeStruct(constructorDef, value, json);
        this.putAll(codecMap);
        this.jsonMap = json;
        this.constructorDef = constructorDef;
    }

    public Struct(Types.ConstructorDef constructorDef, Object value) {
        this(constructorDef, value, new HashMap<String, String>());
    }

    private static Map<String, Codec> decodeStruct(Types.ConstructorDef types, Object value, Map<String, String> jsonMap) {
        if (Utils.isHex(value)) {
            return Struct.decodeStruct(types, Utils.hexToU8a((String)value), jsonMap);
        }
        if (Utils.isU8a(value)) {
            List<Codec> values = CodecUtils.decodeU8a(Utils.u8aToU8a(value), types);
            LinkedHashMap ret = Maps.newLinkedHashMap();
            List<String> names = types.getNames();
            for (int i = 0; i < names.size(); ++i) {
                ret.put(names.get(i), values.get(i));
            }
            return ret;
        }
        if (value == null) {
            return new HashMap<String, Codec>(0);
        }
        return Struct.decodeStructFromObject(types, value, jsonMap);
    }

    private static Map<String, Codec> decodeStructFromObject(Types.ConstructorDef types, Object value, Map<String, String> jsonMap) {
        List<String> names = types.getNames();
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (int i = 0; i < names.size(); ++i) {
            List valueList;
            String key = names.get(i);
            Types.ConstructorCodec type = types.getTypes().get(i);
            if (value.getClass().isArray()) {
                valueList = CodecUtils.arrayLikeToList(value);
                Object v = valueList.get(i);
                ret.put(key, Struct.genInstance(type, v));
                continue;
            }
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                String jsonKey = null;
                jsonKey = jsonMap.containsKey(key) && !valueMap.containsKey(key) ? jsonMap.get(key) : key;
                Object mapped = valueMap.get(jsonKey);
                ret.put(key, Struct.genInstance(type, mapped));
                continue;
            }
            if (value instanceof List) {
                valueList = (List)value;
                ret.put(key, Struct.genInstance(type, valueList.get(i)));
                continue;
            }
            Object field = ReflectionUtils.getField(value, key);
            ret.put(key, Struct.genInstance(type, field));
        }
        return ret;
    }

    private static <T extends Codec> T genInstance(Types.ConstructorCodec<T> type, Object value) {
        Class<T> tClass = type.getTClass();
        if (tClass.isInstance(value) && !Utils.isContainer(value)) {
            return (T)((Codec)value);
        }
        T t1 = type.newInstance(value);
        return t1;
    }

    public static Types.ConstructorCodec<Struct> with(Types.ConstructorDef types) {
        return new Builder(types);
    }

    @Override
    public int getEncodedLength() {
        int allLength = 0;
        for (Codec value : this.values()) {
            allLength += value.getEncodedLength();
        }
        return allLength;
    }

    public List<Codec> toArray() {
        return Lists.newArrayList(this.values());
    }

    @Override
    public boolean eq(Object other) {
        return CodecUtils.compareMap(this, other);
    }

    @Override
    public String toHex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object toJson() {
        JSONObject jsonObject = new JSONObject();
        this.forEach((k, v) -> jsonObject.put(k, v.toJson()));
        return jsonObject;
    }

    @Override
    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        ArrayList collect = Lists.newArrayList();
        for (Codec entry : this.toArray()) {
            byte[] bytes = entry.toU8a(isBare);
            collect.add(bytes);
        }
        byte[] bytes = Utils.u8aConcat(collect);
        return bytes;
    }

    public static Types.ConstructorCodec<Struct> builder() {
        return new Types.ConstructorCodec<Struct>(){

            @Override
            public Struct newInstance(Object ... values) {
                if (values.length == 2) {
                    return new Struct((Types.ConstructorDef)values[0], values[1], null);
                }
                return new Struct((Types.ConstructorDef)values[0], values[1], (Map)values[2]);
            }

            @Override
            public Class<Struct> getTClass() {
                return Struct.class;
            }
        };
    }

    public <T> T getField(String key) {
        Codec codec = (Codec)this.get(key);
        if (codec == null) {
            logger.error(" no such field named {}, current {}", (Object)key, this.keySet());
        }
        return (T)codec;
    }

    @Override
    public boolean isEmpty() {
        for (Codec value : this.values()) {
            if (value.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static class Builder
    implements Types.ConstructorCodec<Struct> {
        Types.ConstructorDef types;

        Builder(Types.ConstructorDef types) {
            this.types = types;
        }

        @Override
        public Struct newInstance(Object ... values) {
            Struct instance = null;
            instance = values.length == 1 ? new Struct(this.types, values[0]) : new Struct(this.types, values[0], (Map)values[1]);
            return instance;
        }

        @Override
        public Class<Struct> getTClass() {
            return Struct.class;
        }
    }
}

