/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.AbstractArray;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.utils.Utils;

public class Tuple
extends AbstractArray<Codec> {
    private Types.ConstructorDef types;

    public Tuple(Types.ConstructorDef types, Object value) {
        List<Codec> codecs = Tuple.decodeTuple(types.getTypes(), value);
        this.addAll(codecs);
        this.types = types;
    }

    private static List<Codec> decodeTuple(List<Types.ConstructorCodec> types, Object value) {
        if (Utils.isU8a(value)) {
            ArrayList results = Lists.newArrayList();
            CodecUtils.decodeU8a(Utils.u8aToU8a(value), types, results);
            return results;
        }
        if (Utils.isHex(value)) {
            return Tuple.decodeTuple(types, Utils.hexToU8a((String)value));
        }
        List<Object> list = CodecUtils.arrayLikeToList(value);
        ArrayList ret = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i < types.size(); ++i) {
                ret.add(types.get(i).newInstance(list.get(i)));
            }
        } else {
            for (int i = 0; i < types.size(); ++i) {
                ret.add(types.get(i).newInstance(value));
            }
        }
        return ret;
    }

    static Types.ConstructorCodec<Tuple> with(List<Types.ConstructorCodec> types) {
        return Tuple.with(new Types.ConstructorDef(types));
    }

    static Types.ConstructorCodec<Tuple> with(Types.ConstructorDef types) {
        return new Builder(types);
    }

    @Override
    public int getEncodedLength() {
        return this.stream().mapToInt(e -> e.getEncodedLength()).sum();
    }

    public List<String> getTypes() {
        return this.types.getNames();
    }

    @Override
    public String toString() {
        return JSON.toJSONString((Object)this.toJson());
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return Utils.u8aConcat(this.stream().map(e -> e.toU8a(isBare)).collect(Collectors.toList()));
    }

    static class Builder
    implements Types.ConstructorCodec<Tuple> {
        Types.ConstructorDef types;

        public Builder(Types.ConstructorDef types) {
            this.types = types;
        }

        @Override
        public Tuple newInstance(Object ... values) {
            return new Tuple(this.types, values[0]);
        }

        @Override
        public Class<Tuple> getTClass() {
            return Tuple.class;
        }
    }
}

