/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.types.codec.U8a;
import org.polkadot.utils.Utils;

public class U8aFixed
extends U8a {
    public U8aFixed(Object value, int bitLength) {
        super(U8aFixed.decodeU8aFixed(value, bitLength <= 0 ? 256 : bitLength));
    }

    private static Object decodeU8aFixed(Object value, int bitLength) {
        if (value == null) {
            value = new byte[0];
        }
        if (bitLength <= 0) {
            bitLength = 256;
        }
        if (Utils.isU8a(value)) {
            int byteLength;
            byte[] ba = Utils.u8aToU8a(value);
            byte[] sub = ArrayUtils.subarray((byte[])ba, (int)0, (int)(byteLength = bitLength / 8));
            if (sub.length == byteLength) {
                return sub;
            }
            byte[] u8a = new byte[byteLength];
            for (int i = 0; i < u8a.length && i < sub.length; ++i) {
                u8a[i] = sub[i];
            }
            return u8a;
        }
        if (value.getClass().isArray() || value instanceof String) {
            return U8aFixed.decodeU8aFixed(Utils.u8aToU8a(value), bitLength);
        }
        return value;
    }

    int bitLength() {
        return this.length() * 8;
    }
}

