/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v0;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.MetadataUtils;
import org.polkadot.types.metadata.Types;
import org.polkadot.types.metadata.v0.Calls;
import org.polkadot.types.metadata.v0.Events;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Type;
import org.polkadot.utils.Utils;

public class MetadataV0
extends Struct
implements Types.MetadataInterface {
    public MetadataV0(Object value) {
        super(new Types.ConstructorDef().add("outerEvent", Events.OuterEventMetadata.class).add("modules", Vector.with(TypesUtils.getConstructorCodec(Modules.RuntimeModuleMetadata.class))).add("outerDispatch", Calls.OuterDispatchMetadata.class), MetadataV0.decodeMetadata(value));
    }

    static Object decodeMetadata(Object value) {
        if (Utils.isHex(value)) {
            return MetadataV0.decodeMetadata(Utils.hexToU8a((String)value));
        }
        if (Utils.isU8a(value)) {
            byte[] bytes = (byte[])value;
            Pair<Integer, BigInteger> pair = Utils.compactFromU8a(bytes);
            return bytes.length == (Integer)pair.getKey() + ((BigInteger)pair.getValue()).intValue() ? ArrayUtils.subarray((byte[])bytes, (int)((Integer)pair.getKey()), (int)bytes.length) : bytes;
        }
        return value;
    }

    public Vector<Calls.OuterDispatchCall> getCalls() {
        return (Vector)((Calls.OuterDispatchMetadata)this.getField("outerDispatch")).getField("calls");
    }

    public Vector<Events.OuterEventMetadataEvent> getEvents() {
        return (Vector)((Events.OuterEventMetadata)this.getField("outerEvent")).getField("events");
    }

    public Vector<Modules.RuntimeModuleMetadata> getModules() {
        return (Vector)this.getField("modules");
    }

    private List<Object> getArgNames() {
        return this.getModules().stream().map(runtimeModuleMetadata -> {
            Modules.ModuleMetadata moduleMetadata = (Modules.ModuleMetadata)runtimeModuleMetadata.getField("module");
            Modules.CallMetadata call = (Modules.CallMetadata)moduleMetadata.getField("call");
            Vector functions = (Vector)call.getField("functions");
            return functions.stream().map(fn -> {
                Vector arguments = (Vector)fn.getField("arguments");
                return arguments.stream().map(functionArgumentMetadata -> {
                    Type type = (Type)functionArgumentMetadata.getField("type");
                    return type.toString();
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }

    private List<Object> getEventNames() {
        return this.getEvents().stream().map(outerEventMetadataEvent -> outerEventMetadataEvent.getEvents().stream().map(eventMetadata -> {
            Vector arguments = (Vector)eventMetadata.getField("arguments");
            return arguments.stream().map(argument -> argument.toString()).collect(Collectors.toList());
        })).collect(Collectors.toList());
    }

    private List<Object> getStorageNames() {
        return this.getModules().stream().map(runtimeModuleMetadata -> {
            Option storage = (Option)runtimeModuleMetadata.getField("storage");
            if (storage.isSome()) {
                Vector functions = (Vector)((Modules.StorageMetadata)storage.unwrap()).getField("functions");
                return functions.stream().map(fn -> {
                    Modules.StorageFunctionType type = (Modules.StorageFunctionType)fn.getField("type");
                    if (type.isMap()) {
                        return Lists.newArrayList((Object[])new String[]{type.asMap().getField("key").toString(), type.asMap().getField("value").toString()});
                    }
                    return Lists.newArrayList((Object[])new String[]{type.asType().toString()});
                }).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> getUniqTypes(boolean throwError) {
        List<Object> types = MetadataUtils.flattenUniq(Lists.newArrayList((Object[])new Object[]{this.getArgNames(), this.getEventNames(), this.getStorageNames()}));
        ArrayList<String> ret = new ArrayList<String>();
        types.forEach((? super T type) -> ret.add((String)type));
        MetadataUtils.validateTypes(ret, throwError);
        return ret;
    }
}

