/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v0;

import com.google.common.collect.Lists;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.Enum;
import org.polkadot.types.codec.EnumType;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v1.Storage;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.Text;
import org.polkadot.types.primitive.Type;
import org.polkadot.types.primitive.U16;

public interface Modules {

    public static class RuntimeModuleMetadata
    extends Struct {
        public RuntimeModuleMetadata(Object value) {
            super(new Types.ConstructorDef().add("prefix", Text.class).add("module", ModuleMetadata.class).add("storage", Option.with(TypesUtils.getConstructorCodec(StorageMetadata.class))), value);
        }

        public ModuleMetadata getModule() {
            return (ModuleMetadata)this.getField("module");
        }

        public Text getPrefix() {
            return (Text)this.getField("prefix");
        }

        public Option<StorageMetadata> getStorage() {
            return (Option)this.getField("storage");
        }
    }

    public static class StorageMetadata
    extends Struct {
        public StorageMetadata(Object value) {
            super(new Types.ConstructorDef().add("prefix", Text.class).add("functions", Vector.with(TypesUtils.getConstructorCodec(StorageFunctionMetadata.class))), value);
        }

        public Text getPrefix() {
            return (Text)this.getField("prefix");
        }

        public Vector<StorageFunctionMetadata> getFunctions() {
            return (Vector)this.getField("functions");
        }
    }

    public static class StorageFunctionMetadata
    extends Struct {
        public StorageFunctionMetadata(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("modifier", StorageFunctionModifier.class).add("type", StorageFunctionType.class).add("default", Bytes.class).add("documentation", Vector.with(TypesUtils.getConstructorCodec(Text.class))), value);
        }

        public StorageFunctionType getType() {
            return (StorageFunctionType)this.getField("type");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }

        public StorageFunctionModifier getModifier() {
            return (StorageFunctionModifier)this.getField("modifier");
        }

        public Bytes getDefault() {
            return (Bytes)this.getField("default");
        }

        public Vector<Text> getDocumentation() {
            return (Vector)this.getField("documentation");
        }
    }

    public static class StorageFunctionMetadataValue {
        String name;
        StorageFunctionModifier modifier;
        StorageFunctionType type;
        Bytes defalut;
        Vector<Text> documentation;
    }

    public static class StorageFunctionType
    extends EnumType {
        public StorageFunctionType(Object value, int index) {
            super(new Types.ConstructorDef().add("PlainType", PlainType.class).add("MapType", MapType.class), value, index, null);
        }

        public StorageFunctionType(Object value) {
            this(value, -1);
        }

        public boolean isMap() {
            return this.toNumber() == 1;
        }

        public MapType asMap() {
            return (MapType)this.value();
        }

        public PlainType asType() {
            return (PlainType)this.value();
        }

        @Override
        public String toString() {
            if (this.isMap()) {
                MapType mapType = this.asMap();
                if (mapType.isLinked) {
                    return "(" + mapType.getField("value").toString() + ", Linkage<" + mapType.getField("key").toString() + ">)";
                }
                return mapType.getField("value").toString();
            }
            return this.asType().toString();
        }
    }

    public static class PlainType
    extends Type {
        public PlainType(Object value) {
            super(value);
        }
    }

    public static class MapType
    extends Struct {
        private boolean isLinked = false;

        public MapType(Object value) {
            super(new Types.ConstructorDef().add("key", Type.class).add("value", Type.class), value);
            Boolean linked;
            if (value instanceof Storage.MapType && (linked = ((Storage.MapType)value).isLinked()).booleanValue()) {
                this.isLinked = true;
            }
            if (value != null && value instanceof MapType && ((MapType)value).isLinked) {
                this.isLinked = true;
            }
        }

        public boolean isLinked() {
            return this.isLinked;
        }

        public Type getKey() {
            return (Type)this.getField("key");
        }

        public Type getValue() {
            return (Type)this.getField("value");
        }
    }

    public static class StorageFunctionModifier
    extends Enum {
        public StorageFunctionModifier(Object value) {
            super(Lists.newArrayList((Object[])new String[]{"Optional", "Default", "Required"}), value);
        }

        public boolean isOptional() {
            return this.toNumber() == 0;
        }
    }

    public static class ModuleMetadata
    extends Struct {
        public ModuleMetadata(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("call", CallMetadata.class), value);
        }

        public CallMetadata getCall() {
            return (CallMetadata)this.getField("call");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }
    }

    public static class CallMetadata
    extends Struct {
        public CallMetadata(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("functions", Vector.with(TypesUtils.getConstructorCodec(FunctionMetadata.class))), value);
        }

        public Vector<FunctionMetadata> getFunctions() {
            return (Vector)this.getField("functions");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }
    }

    public static class FunctionMetadata
    extends Struct {
        public FunctionMetadata(Object value) {
            super(new Types.ConstructorDef().add("id", U16.class).add("name", Text.class).add("arguments", Vector.with(TypesUtils.getConstructorCodec(FunctionArgumentMetadata.class))).add("documentation", Vector.with(TypesUtils.getConstructorCodec(Text.class))), value);
        }

        public Vector<FunctionArgumentMetadata> getArguments() {
            return (Vector)this.getField("arguments");
        }

        public Vector<Text> getDocumentation() {
            return (Vector)this.getField("documentation");
        }

        public U16 getId() {
            return (U16)this.getField("id");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }
    }

    public static class FunctionArgumentMetadata
    extends Struct {
        public FunctionArgumentMetadata(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("type", Type.class), value);
        }

        public Text getName() {
            return (Text)this.get("name");
        }

        public Type getType() {
            return (Type)this.get("type");
        }
    }
}

