/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v1;

import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.EnumType;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.primitive.Bool;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.Null;
import org.polkadot.types.primitive.Text;
import org.polkadot.types.primitive.Type;

public interface Storage {

    public static class MetadataStorageV1
    extends Struct {
        public MetadataStorageV1(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("modifier", MetadataStorageModifier.class).add("type", MetadataStorageType.class).add("fallback", Bytes.class).add("docs", Vector.with(TypesUtils.getConstructorCodec(Text.class))), value);
        }

        public Vector<Text> getDocs() {
            return (Vector)this.getField("docs");
        }

        public Bytes getFallback() {
            return (Bytes)this.getField("fallback");
        }

        public MetadataStorageModifier getModifier() {
            return (MetadataStorageModifier)this.getField("modifier");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }

        public MetadataStorageType getType() {
            return (MetadataStorageType)this.getField("type");
        }
    }

    public static class MetadataStorageType
    extends EnumType {
        public MetadataStorageType(Object value) {
            this(value, -1);
        }

        public MetadataStorageType(Object value, int index) {
            super(new Types.ConstructorDef().add("PlainType", PlainType.class).add("MapType", MapType.class), value, index, null);
        }

        public boolean isMap() {
            return this.toNumber() == 1;
        }

        public MapType asMap() {
            return (MapType)this.value();
        }

        public PlainType asType() {
            return (PlainType)this.value();
        }

        @Override
        public String toString() {
            return this.isMap() ? this.asMap().getValue().toString() : this.asType().toString();
        }
    }

    public static class PlainType
    extends Type {
        public PlainType(Object value) {
            super(value);
        }
    }

    public static class MapType
    extends Struct {
        private boolean isLinked = false;

        public MapType(Object value) {
            super(new Types.ConstructorDef().add("key", Type.class).add("value", Type.class), value);
            Bool isLinked;
            if (value instanceof Struct && (isLinked = (Bool)((Struct)value).getField("isLinked")) != null) {
                this.isLinked = isLinked.rawBool();
            }
        }

        public Type getKey() {
            return (Type)this.getField("key");
        }

        public Type getValue() {
            return (Type)this.getField("value");
        }

        public Boolean isLinked() {
            return this.isLinked;
        }
    }

    public static class MetadataStorageModifier
    extends EnumType {
        public MetadataStorageModifier(Object value) {
            this(value, -1);
        }

        public MetadataStorageModifier(Object value, int index) {
            super(new Types.ConstructorDef().add("Optional", Optional.class).add("Default", Default.class), value, index, null);
        }

        public boolean isOptional() {
            return this.toNumber() == 0;
        }

        @Override
        public Object toJson() {
            return this.toString();
        }
    }

    public static class Optional
    extends Null {
    }

    public static class Default
    extends Null {
    }
}

