/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v1;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.polkadot.types.Codec;
import org.polkadot.types.metadata.v0.Calls;
import org.polkadot.types.metadata.v0.Events;
import org.polkadot.types.metadata.v0.MetadataV0;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.metadata.v1.MetadataV1;

public class ToV0 {
    static Modules.StorageMetadata storageV0(MetadataV1.MetadataModule mod) {
        if (mod.getStorage().isNone()) {
            return null;
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("prefix", mod.getPrefix());
        values.put("functions", mod.getStorage().unwrap().stream().map(storage -> {
            LinkedHashMap<String, Object> storageValues = new LinkedHashMap<String, Object>();
            storageValues.put("name", storage.getName());
            storageValues.put("modifier", storage.getModifier().toNumber());
            storageValues.put("type", new Modules.StorageFunctionType(storage.getType(), -1));
            storageValues.put("default", storage.getFallback());
            storageValues.put("documentation", storage.getDocs());
            return new Modules.StorageFunctionMetadata(storageValues);
        }).collect(Collectors.toList()));
        return new Modules.StorageMetadata(values);
    }

    static Modules.ModuleMetadata moduleV0(MetadataV1.MetadataModule mod) {
        LinkedHashMap<String, Object> callValues = new LinkedHashMap<String, Object>();
        AtomicInteger funId = new AtomicInteger(0);
        callValues.put("name", "Call");
        callValues.put("functions", mod.getCalls().isNone() ? Lists.newArrayList() : mod.getCalls().unwrap().stream().map(metadataCall -> {
            LinkedHashMap<String, Object> funcValues = new LinkedHashMap<String, Object>();
            funcValues.put("id", funId.getAndIncrement());
            funcValues.put("name", metadataCall.getName());
            funcValues.put("arguments", metadataCall.getArgs());
            funcValues.put("documentation", metadataCall.getArgs());
            return new Modules.FunctionMetadata(funcValues);
        }).collect(Collectors.toList()));
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("name", "Module");
        values.put("call", new Modules.CallMetadata(callValues));
        return new Modules.ModuleMetadata(values);
    }

    static List<Modules.RuntimeModuleMetadata> modulesV0(MetadataV1 v1) {
        return v1.getModules().stream().map(mod -> {
            LinkedHashMap<String, Codec> values = new LinkedHashMap<String, Codec>();
            values.put("prefix", mod.getName());
            values.put("module", ToV0.moduleV0(mod));
            values.put("storage", ToV0.storageV0(mod));
            return new Modules.RuntimeModuleMetadata(values);
        }).collect(Collectors.toList());
    }

    static Calls.OuterDispatchMetadata outerDispatchV0(MetadataV1 v1) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        AtomicInteger index = new AtomicInteger(0);
        values.put("name", "Call");
        values.put("calls", v1.getModules().stream().filter(mod -> mod.getCalls().isSome()).map(mod -> {
            LinkedHashMap<String, Object> callValues = new LinkedHashMap<String, Object>();
            callValues.put("name", mod.getPrefix());
            callValues.put("prefix", mod.getName());
            callValues.put("index", index.getAndIncrement());
            return new Calls.OuterDispatchCall(callValues);
        }).collect(Collectors.toList()));
        return new Calls.OuterDispatchMetadata(values);
    }

    static Events.OuterEventMetadata outerEventV0(MetadataV1 v1) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("name", "Event");
        values.put("events", v1.getModules().stream().filter(mod -> mod.getEvents().isSome()).map(mod -> {
            ArrayList eventValues = Lists.newArrayList();
            eventValues.add(mod.getName());
            eventValues.add(mod.getEvents().unwrap().stream().map(event -> {
                LinkedHashMap<String, Codec> eventVaMap = new LinkedHashMap<String, Codec>();
                eventVaMap.put("name", event.getName());
                eventVaMap.put("arguments", event.getArgs());
                eventVaMap.put("documentation", event.getDocs());
                return new Events.EventMetadata(eventVaMap);
            }).collect(Collectors.toList()));
            return new Events.OuterEventMetadataEvent((Object)eventValues);
        }).collect(Collectors.toList()));
        return new Events.OuterEventMetadata(values);
    }

    public static MetadataV0 toV0(MetadataV1 v1) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("outerEvent", ToV0.outerEventV0(v1));
        values.put("modules", ToV0.modulesV0(v1));
        values.put("outerDispatch", ToV0.outerDispatchV0(v1));
        return new MetadataV0(values);
    }
}

