/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.primitive;

import org.polkadot.types.Codec;
import org.polkadot.utils.Utils;

public class Bool
implements Codec {
    boolean raw = false;

    public Bool(Object value) {
        this.raw = Bool.decodeBool(value);
    }

    private static boolean decodeBool(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (Utils.isU8a(value)) {
            byte[] value1 = (byte[])value;
            return value1[0] == 1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return value == null;
    }

    @Override
    public int getEncodedLength() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean eq(Object other) {
        return this.raw == (other instanceof Boolean ? (Boolean)other : Bool.decodeBool(other));
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a());
    }

    @Override
    public Object toJson() {
        return this.raw;
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return new byte[]{(byte)(this.raw ? 1 : 0)};
    }

    public String toString() {
        return this.toJson().toString();
    }

    public boolean rawBool() {
        return this.raw;
    }
}

