/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.primitive;

import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.primitive.StorageData;
import org.polkadot.utils.Utils;

public class Bytes
extends U8a {
    public Bytes(Object value) {
        super(Bytes.decodeBytes(value));
    }

    private static byte[] decodeBytes(Object value) {
        if (value instanceof StorageData) {
            Pair<Integer, BigInteger> pair;
            StorageData u8a = (StorageData)value;
            byte[] bytes = u8a.toU8a();
            return bytes.length == ((BigInteger)(pair = Utils.compactFromU8a(bytes)).getValue()).add(new BigInteger(((Integer)pair.getKey()).toString())).intValue() ? u8a.subarray((Integer)pair.getKey(), u8a.length()).toU8a() : u8a.toU8a();
        }
        if (value instanceof String) {
            byte[] u8a = Utils.u8aToU8a(value);
            return Bytes.decodeBytes(Utils.compactAddLength(u8a));
        }
        if (value instanceof U8a) {
            return ((U8a)value).toU8a();
        }
        if (Utils.isU8a(value)) {
            Pair<Integer, BigInteger> pair = Utils.compactFromU8a(value);
            int offset = (Integer)pair.getKey();
            int length = ((BigInteger)pair.getValue()).intValue();
            return ArrayUtils.subarray((byte[])((byte[])value), (int)offset, (int)(offset + length));
        }
        return (byte[])value;
    }

    @Override
    public int getEncodedLength() {
        return this.length() + Utils.compactToU8a(this.length()).length;
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return isBare ? super.toU8a(isBare) : Utils.compactAddLength(this.raw);
    }
}

