/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.primitive;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.direct.IFunction;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Bytes;

public class StorageKey
extends Bytes {
    private Modules.StorageFunctionMetadata meta;
    private String outputType;

    public StorageKey(Object value) {
        super(StorageKey.decodeStorageKey(value));
        this.meta = StorageKey.getMeta(value);
        this.outputType = StorageKey.getType(value);
    }

    static String getType(Object value) {
        if (value instanceof StorageKey) {
            return ((StorageKey)value).outputType;
        }
        if (value instanceof StorageFunction) {
            return ((StorageFunction)value).meta.getType().toString();
        }
        if (value.getClass().isArray()) {
            List<Object> elements = CodecUtils.arrayLikeToList(value);
            return ((StorageFunction)elements.get((int)0)).meta.getType().toString();
        }
        return null;
    }

    static Modules.StorageFunctionMetadata getMeta(Object value) {
        if (value instanceof StorageKey) {
            return ((StorageKey)value).meta;
        }
        if (value instanceof StorageFunction) {
            return ((StorageFunction)value).meta;
        }
        if (value.getClass().isArray()) {
            List<Object> elements = CodecUtils.arrayLikeToList(value);
            return ((StorageFunction)elements.get((int)0)).meta;
        }
        return null;
    }

    static Object decodeStorageKey(Object value) {
        List<Object> elements;
        Object remove;
        if (value instanceof IFunction) {
            byte[] apply = ((StorageFunction)value).apply(new Object[0]);
            return new U8a(apply);
        }
        if (value.getClass().isArray() && (remove = (elements = CodecUtils.arrayLikeToList(value)).remove(0)) instanceof StorageFunction) {
            Object arg = elements.get(0);
            List<Object> args = CodecUtils.arrayLikeToList(arg);
            return ((StorageFunction)remove).apply(args.toArray(ArrayUtils.EMPTY_OBJECT_ARRAY));
        }
        return value;
    }

    public Modules.StorageFunctionMetadata getMeta() {
        return this.meta;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public static abstract class StorageFunction
    implements IFunction<byte[]> {
        protected Modules.StorageFunctionMetadata meta;
        protected String method;
        protected String section;
        StorageKey headKey;

        public abstract byte[] apply(Object ... var1);

        public abstract Object toJson();

        public Modules.StorageFunctionMetadata getMeta() {
            return this.meta;
        }

        public void setMeta(Modules.StorageFunctionMetadata meta) {
            this.meta = meta;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }

        public StorageKey getHeadKey() {
            return this.headKey;
        }

        public void setHeadKey(StorageKey headKey) {
            this.headKey = headKey;
        }
    }
}

