/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.primitive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.polkadot.types.primitive.Text;

public class Type
extends Text {
    static final String[] ALLOWED_BOXES = new String[]{"Compact", "Option", "Vec"};
    private int originalLength;

    public Type(Object value) {
        super(Type.decodeType(new Text(value).toString()));
        this.originalLength = new Text(value).getEncodedLength();
    }

    private static String decodeType(String value) {
        ArrayList mappings = Lists.newArrayList((Object[])new Mapper[]{Type.alias("<T::InherentOfflineReport as InherentOfflineReport>::Inherent", "InherentOfflineReport"), Type.alias("Proposal<T::AccountId, BalanceOf<T>>", "TreasuryProposal"), Type.cleanupCompact(), Type.removeTraits(), Type.removePairOf(), Type.removeWrap("Box"), Type.removeGenerics(), Type.alias("String", "Text"), Type.alias("\\\\(\\\\)", "Null"), Type.alias("Compact<Index>", "IndexCompact"), Type.alias("Vec<u8>", "Bytes"), Type.alias("RawAddress", "Address"), Type.alias("Lookup::Source", "Address"), Type.alias("Lookup::Target", "AccountId"), Type.flattenSingleTuple()});
        for (Mapper mapping : mappings) {
            value = mapping.apply(value);
        }
        return value.trim();
    }

    @Override
    public int getEncodedLength() {
        return this.originalLength;
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        throw new UnsupportedOperationException("Type::toU8a: unimplemented");
    }

    private static Mapper alias(String src, String dest) {
        return value -> value.replace(src, dest);
    }

    private static Mapper cleanupCompact() {
        return value -> {
            for (int index = 0; index < value.length(); ++index) {
                int end;
                if (value.charAt(index) != '<' || (end = Type.findClosing(value, index + 1) - 14) < 0 || end >= value.length() || end + 14 < 0 || end + 14 >= value.length() || !value.substring(end, end + 14).equals(" as HasCompact")) continue;
                String substring = value.substring(index + 1, end);
                value = "Compact<" + substring + ">";
            }
            return value;
        };
    }

    private static int findClosing(String value, int start) {
        int depth = 0;
        for (int index = start; index < value.length(); ++index) {
            if (value.charAt(index) == '>') {
                if (depth <= 0) {
                    return index;
                }
                --depth;
                continue;
            }
            if (value.charAt(index) != '<') continue;
            ++depth;
        }
        throw new RuntimeException("Unable to find closing matching <> on " + value + " (start " + start);
    }

    private static Mapper flattenSingleTuple() {
        return value -> value.replaceAll("\\(([^,]*)\\)", "$1");
    }

    private static Mapper removeGenerics() {
        return value -> {
            for (int index = 0; index < value.length(); ++index) {
                if (value.charAt(index) != '<') continue;
                int finalIndex = index;
                String finalValue = value;
                String findBox = Arrays.stream(ALLOWED_BOXES).filter(box -> {
                    int start = finalIndex - box.length();
                    return start >= 0 && finalValue.substring(start, start + box.length()).equals(box);
                }).findFirst().orElse(null);
                if (findBox != null) continue;
                int end = Type.findClosing(value, index + 1);
                value = value.substring(0, index) + value.substring(end + 1);
            }
            return value;
        };
    }

    private static Mapper removePairOf() {
        return value -> {
            for (int index = 0; index < value.length() && index + 7 <= value.length(); ++index) {
                if (!value.substring(index, index + 7).equals("PairOf<")) continue;
                int start = index + 7;
                int end = Type.findClosing(value, start);
                String type = value.substring(start, end);
                value = value.substring(0, index) + "(" + type + "," + type + ")" + value.substring(end + 1);
            }
            return value;
        };
    }

    private static Mapper removeTraits() {
        return value -> value.replaceAll("\\s", "").replace("T::", "").replace("Self::", "").replace("system::", "").replace("<TasTrait>::", "").replace("<SelfasTrait>::", "").replace("<LookupasStaticLookup>", "Lookup").replace("::Type", "").replace("wasm::", "");
    }

    private static Mapper removeWrap(String check) {
        String finalCheck = check = check + "<";
        return value -> {
            int index = 0;
            while (index != -1) {
                index = value.indexOf(finalCheck);
                if (index == -1) continue;
                int start = index + finalCheck.length();
                int end = Type.findClosing(value, start);
                value = value.substring(0, index) + value.substring(start, end) + value.substring(end + 1);
            }
            return value;
        };
    }

    static interface Mapper {
        public String apply(String var1);
    }
}

