/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import com.google.common.primitives.UnsignedBytes;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.types.primitive.U32;
import org.polkadot.utils.Utils;

public class AccountIndex
extends U32 {
    public static final BigInteger ENUMSET_SIZE = BigInteger.valueOf(64L);
    public static final byte PREFIX_1BYTE = UnsignedBytes.checkedCast((long)239L);
    public static final byte PREFIX_2BYTE = UnsignedBytes.checkedCast((long)252L);
    public static final byte PREFIX_4BYTE = UnsignedBytes.checkedCast((long)253L);
    public static final byte PREFIX_8BYTE = UnsignedBytes.checkedCast((long)254L);
    public static final BigInteger MAX_1BYTE = BigInteger.valueOf(PREFIX_1BYTE);
    public static final BigInteger MAX_2BYTE = BigInteger.ONE.shiftLeft(16);
    public static final BigInteger MAX_4BYTE = BigInteger.ONE.shiftLeft(32);

    public AccountIndex(Object value) {
        super(AccountIndex.decodeAccountIndex(value));
    }

    static Object decodeAccountIndex(Object value) {
        if (value instanceof AccountIndex) {
            return ((AccountIndex)value).toBn();
        }
        if (value instanceof BigInteger || value instanceof Number || Utils.isHex(value) || Utils.isU8a(value)) {
            return value;
        }
        return AccountIndex.decodeAccountIndex(AddressCodec.decodeAddress((byte[])value));
    }

    static int calcLength(Number _value) {
        BigInteger value = Utils.bnToBn(_value);
        if (value.compareTo(MAX_1BYTE) <= 0) {
            return 1;
        }
        if (value.compareTo(MAX_2BYTE) < 0) {
            return 2;
        }
        if (value.compareTo(MAX_4BYTE) < 0) {
            return 4;
        }
        return 8;
    }

    static int[] readLength(byte[] input) {
        if (input.length == 0) {
            return new int[]{0, 1};
        }
        int first = UnsignedBytes.toInt((byte)input[0]);
        if (first == UnsignedBytes.toInt((byte)PREFIX_2BYTE)) {
            return new int[]{1, 2};
        }
        if (first == UnsignedBytes.toInt((byte)PREFIX_4BYTE)) {
            return new int[]{1, 4};
        }
        if (first == UnsignedBytes.toInt((byte)PREFIX_8BYTE)) {
            return new int[]{1, 8};
        }
        return new int[]{0, 1};
    }

    static byte[] writeLength(byte[] input) {
        switch (input.length) {
            case 2: {
                return new byte[]{PREFIX_2BYTE};
            }
            case 4: {
                return new byte[]{PREFIX_4BYTE};
            }
            case 8: {
                return new byte[]{PREFIX_8BYTE};
            }
        }
        return new byte[0];
    }

    @Override
    public boolean eq(Object other) {
        if (other instanceof BigInteger || other instanceof Number) {
            return super.eq(other);
        }
        return super.eq(new AccountIndex(other));
    }

    @Override
    public Object toJson() {
        return super.toJson();
    }

    @Override
    public String toString() {
        int length = AccountIndex.calcLength(this);
        return AddressCodec.encodeAddress(ArrayUtils.subarray((byte[])this.toU8a(), (int)0, (int)length));
    }
}

