/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.common.keyring.Types;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Method;
import org.polkadot.types.type.ExtrinsicSignature;
import org.polkadot.types.type.Hash;
import org.polkadot.utils.Utils;
import org.polkadot.utils.UtilsCrypto;

public class Extrinsic
extends Struct
implements Types.IExtrinsic {
    public Extrinsic(Object value) {
        super(new Types.ConstructorDef().add("signature", ExtrinsicSignature.class).add("method", Method.class), Extrinsic.decodeExtrinsic(value));
    }

    static Object decodeExtrinsic(Object value) {
        if (Utils.isU8a(value)) {
            Pair<Integer, BigInteger> pair = Utils.compactFromU8a(value);
            int offset = (Integer)pair.getKey();
            int length = ((BigInteger)pair.getValue()).intValue();
            return ArrayUtils.subarray((byte[])((byte[])value), (int)offset, (int)(offset + length));
        }
        if (value.getClass().isArray() || Utils.isHex(value)) {
            int length;
            Pair<Integer, BigInteger> pair;
            int offset;
            byte[] u8a = Utils.u8aToU8a(value);
            boolean withPrefix = u8a.length == (offset = ((Integer)(pair = Utils.compactFromU8a(u8a)).getKey()).intValue()) + (length = ((BigInteger)pair.getValue()).intValue());
            return Extrinsic.decodeExtrinsic(withPrefix ? u8a : Utils.compactAddLength(u8a));
        }
        if (value instanceof Method) {
            LinkedHashMap values = Maps.newLinkedHashMap();
            values.put("method", value);
            return values;
        }
        return value;
    }

    @Override
    public List<Codec> getArgs() {
        return this.getMethod().getArgs();
    }

    @Override
    public Types.ConstructorDef getArgsDef() {
        return this.getMethod().getArgsDef();
    }

    @Override
    public byte[] getCallIndex() {
        return this.getMethod().getCallIndex();
    }

    @Override
    public byte[] getData() {
        return this.getMethod().getData();
    }

    @Override
    public int getEncodedLength() {
        int length = this.length();
        return length + Utils.compactToU8a(length).length;
    }

    @Override
    public U8a getHash() {
        return new Hash(UtilsCrypto.blake2AsU8a(this.toU8a(), 256));
    }

    @Override
    public boolean hasOrigin() {
        return this.getMethod().hasOrigin();
    }

    @Override
    public boolean isSigned() {
        return this.getSignature().isSigned();
    }

    public int length() {
        return this.toU8a(true).length;
    }

    @Override
    public Modules.FunctionMetadata getMeta() {
        return this.getMethod().getMeta();
    }

    @Override
    public Method getMethod() {
        return (Method)this.getField("method");
    }

    @Override
    public ExtrinsicSignature getSignature() {
        return (ExtrinsicSignature)this.getField("signature");
    }

    @Override
    public Extrinsic addSignature(Object signer, byte[] signature, Object nonce, byte[] era) {
        this.getSignature().addSignature(signer, signature, nonce, era);
        return this;
    }

    @Override
    public Extrinsic sign(Types.KeyringPair account, Types.SignatureOptions options) {
        this.getSignature().sign(this.getMethod(), account, options);
        return this;
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a());
    }

    @Override
    public Object toJson() {
        return this.toHex();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        byte[] encoded = super.toU8a(false);
        return isBare ? encoded : Utils.compactAddLength(encoded);
    }

    public static class ExtrinsicValue {
        Method method;
        ExtrinsicSignature signature;
    }
}

