/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.Compact;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.primitive.U64;
import org.polkadot.types.type.AccountId;
import org.polkadot.types.type.BlockNumber;
import org.polkadot.types.type.Digest;
import org.polkadot.types.type.Hash;
import org.polkadot.utils.UtilsCrypto;

public class Header
extends Struct {
    public Header(Object value) {
        super(new Types.ConstructorDef().add("parentHash", Hash.class).add("number", Compact.with(TypesUtils.getConstructorCodec(BlockNumber.class))).add("stateRoot", Hash.class).add("extrinsicsRoot", Hash.class).add("digest", Digest.class), value == null ? new LinkedHashMap() : value);
    }

    public BlockNumber getBlockNumber() {
        Compact number = (Compact)this.getField("number");
        return new BlockNumber(number.toBn());
    }

    public Digest getDigest() {
        return (Digest)this.getField("digest");
    }

    public Hash getExtrinsicsRoot() {
        return (Hash)this.getField("extrinsicsRoot");
    }

    public Hash getHash() {
        byte[] bytes = UtilsCrypto.blake2AsU8a(this.toU8a(), 256);
        return new Hash(bytes);
    }

    public BlockNumber getNumber() {
        return this.getBlockNumber();
    }

    public Hash getParentHash() {
        return (Hash)this.getField("parentHash");
    }

    public Hash getStateRoot() {
        return (Hash)this.getField("stateRoot");
    }

    public static class HeaderExtended
    extends Header {
        private AccountId author;

        public HeaderExtended(Header header, List<AccountId> sessionValidators) {
            super((Object)header);
            if (header == null || header.getDigest() == null || CollectionUtils.isEmpty(sessionValidators)) {
                return;
            }
            Digest.DigestItem item = header.getDigest().getLogs().stream().filter(log -> log.isConsensus()).findFirst().orElse(null);
            U64 slot = null;
            if (item != null) {
                Digest.Consensus consensus = item.getAsConsensus();
                if (consensus.isAura()) {
                    slot = (U64)consensus.asAura().getKey();
                }
            } else {
                item = header.getDigest().getLogs().stream().filter(log -> log.isSeal()).findFirst().orElse(null);
                if (item != null) {
                    slot = item.getAsSeal().slot();
                }
            }
            if (slot != null) {
                this.author = sessionValidators.get(slot.intValue() % sessionValidators.size());
            }
        }

        public AccountId getAuthor() {
            return this.author;
        }

        @Override
        public Object toJson() {
            JSONObject jsonObject = (JSONObject)super.toJson();
            jsonObject.put("author", this.author != null ? this.author.toJson() : null);
            return jsonObject;
        }
    }

    public static class HeaderValue {
        Digest digest;
        byte[] extrinsicsRoot;
        int number;
        byte[] parentHash;
        byte[] stateRoot;
    }
}

