/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils.crypto;

import java.util.Arrays;
import java.util.Map;
import org.polkadot.utils.MapUtils;
import org.polkadot.utils.Utils;

public class Base58 {
    public static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final char ENCODED_ZERO = ALPHABET[0];
    private static final int[] INDEXES = new int[128];
    static Map<String, String> testCases;

    public static String encode(byte[] input) {
        int zeros;
        if (input.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        input = Arrays.copyOf(input, input.length);
        char[] encoded = new char[input.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input.length) {
            encoded[--outputStart] = ALPHABET[Base58.divmod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    public static byte[] decode(String input) {
        int zeros;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            int digit;
            char c = input.charAt(i);
            int n = digit = c < '\u0080' ? INDEXES[c] : -1;
            if (digit < 0) {
                String msg = "Invalid characters,c=" + c;
                throw new RuntimeException(msg);
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    public static void main(String[] args) {
        String encode;
        String result;
        byte[] decode;
        for (Map.Entry<String, String> entry : testCases.entrySet()) {
            System.out.println(entry.getKey());
            decode = Base58.decode(entry.getKey());
            result = Utils.u8aToHex(decode, -1, false);
            System.out.println(result.toUpperCase());
            System.out.println(entry.getValue());
            if (!result.equalsIgnoreCase(entry.getValue())) {
                throw new UnsupportedOperationException();
            }
            encode = Base58.encode(decode);
            System.out.println(encode);
        }
        System.out.println("=========");
        for (Map.Entry<String, String> entry : testCases.entrySet()) {
            System.out.println(entry.getKey());
            decode = org.bitcoinj.core.Base58.decode((String)entry.getKey());
            result = Utils.u8aToHex(decode, -1, false);
            System.out.println(result.toUpperCase());
            System.out.println(entry.getValue());
            if (!result.equalsIgnoreCase(entry.getValue())) {
                throw new UnsupportedOperationException();
            }
            encode = org.bitcoinj.core.Base58.encode((byte[])decode);
            System.out.println(encode);
        }
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
        testCases = MapUtils.ofMap("16UjcYNBG9GTK4uq2f7yYEbuifqCzoLMGS", "003c176e659bea0f29a3e9bf7880c112b1b31b4dc826268187", "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY", "2AD43593C715FDD31C61141ABD04A99FD6822C8558854CCDE39A5684E7A56DA27D1D21");
    }
}

