/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils.crypto;

import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.polkadot.utils.Utils;
import org.polkadot.utils.crypto.TweetNaCl;
import org.polkadot.utils.crypto.Types;

public class Nacl {
    public static byte[] naclDecrypt(byte[] encrypted, byte[] nonce, byte[] secret) {
        return TweetNaCl.secretbox_open(encrypted, nonce, secret);
    }

    public static Encrypted naclEncrypt(byte[] message, byte[] secret) {
        return Nacl.naclEncrypt(message, secret, Utils.randomAsU8a(24));
    }

    public static Encrypted naclEncrypt(byte[] message, byte[] secret, byte[] nonce) {
        Encrypted result = new Encrypted();
        result.encrypted = TweetNaCl.secretbox(message, nonce, secret);
        result.nonce = nonce;
        return result;
    }

    public static Types.Keypair naclKeypairFromSeed(byte[] seed) {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
        EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)spec);
        byte[] priv = privKey.getH();
        byte[] pub = privKey.getA().toByteArray();
        return new Types.Keypair(pub, priv);
    }

    public static byte[] naclSign(byte[] message, Types.Keypair keypair) {
        try {
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
            EdDSAPrivateKeySpec edPrivateKey = new EdDSAPrivateKeySpec((EdDSAParameterSpec)spec, keypair.secretKey);
            EdDSAPrivateKey privateKey = new EdDSAPrivateKey(edPrivateKey);
            sgr.initSign((PrivateKey)privateKey);
            sgr.update(message);
            return sgr.sign();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean naclVerify(byte[] message, byte[] signature, byte[] publicKey) {
        try {
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
            EdDSAPublicKeySpec edPublicKey = new EdDSAPublicKeySpec(publicKey, (EdDSAParameterSpec)spec);
            EdDSAPublicKey pubKey = new EdDSAPublicKey(edPublicKey);
            sgr.initVerify((PublicKey)pubKey);
            sgr.update(message);
            return sgr.verify(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class Encrypted {
        byte[] encrypted;
        byte[] nonce;

        public byte[] getEncrypted() {
            return this.encrypted;
        }

        public byte[] getNonce() {
            return this.nonce;
        }
    }
}

