/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils.crypto;

import java.util.Arrays;
import org.polkadot.utils.crypto.ISR25591;
import org.polkadot.utils.crypto.JniSR25591;
import org.polkadot.utils.crypto.Types;

public class Schnorrkel {
    private static ISR25591 createSR25591() {
        return new JniSR25591();
    }

    private static byte[] extractPublicKey(byte[] keyPair) {
        return Arrays.copyOfRange(keyPair, 64, keyPair.length);
    }

    private static byte[] extractSecretKey(byte[] keyPair) {
        return Arrays.copyOfRange(keyPair, 0, 64);
    }

    private static Types.Keypair toKeyPair(byte[] keyPair) {
        return new Types.Keypair(Schnorrkel.extractPublicKey(keyPair), Schnorrkel.extractSecretKey(keyPair));
    }

    public static Types.Keypair schnorrkelKeypairFromSeed(byte[] seed) {
        byte[] kp = new byte[96];
        Schnorrkel.createSR25591().sr25519_keypair_from_seed(kp, seed);
        return Schnorrkel.toKeyPair(kp);
    }

    public static byte[] schnorrkelSign(byte[] message, Types.Keypair keypair) {
        byte[] sig = new byte[64];
        Schnorrkel.createSR25591().sr25519_sign(sig, keypair.getPublicKey(), keypair.getSecretKey(), message, message.length);
        return sig;
    }

    public static boolean schnorrkelVerify(byte[] message, byte[] signature, byte[] publicKey) {
        return Schnorrkel.createSR25591().sr25519_verify(signature, message, message.length, publicKey);
    }
}

