/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class TweetNaCl {
    public static final int crypto_auth_hmacsha512256_tweet_BYTES = 32;
    public static final int crypto_auth_hmacsha512256_tweet_KEYBYTES = 32;
    public static final int BOX_PUBLIC_KEY_BYTES = 32;
    public static final int BOX_SECRET_KEY_BYTES = 32;
    public static final int BOX_SHARED_KEY_BYTES = 32;
    public static final int BOX_NONCE_BYTES = 24;
    public static final int BOX_OVERHEAD_BYTES = 16;
    public static final int SIGNATURE_SIZE_BYTES = 64;
    public static final int SIGN_PUBLIC_KEY_BYTES = 32;
    public static final int SIGN_SECRET_KEY_BYTES = 64;
    public static final int SIGN_KEYPAIR_SEED_BYTES = 32;
    public static final int SECRETBOX_KEY_BYTES = 32;
    public static final int SECRETBOX_NONCE_BYTES = 24;
    public static final int SECRETBOX_OVERHEAD_BYTES = 16;
    public static final int HASH_SIZE_BYTES = 64;
    private static final int SECRETBOX_INTERNAL_OVERHEAD_BYTES = 32;
    private static byte[] _0 = new byte[16];
    private static byte[] _9 = new byte[32];
    private static final int GF_LEN = 16;
    private static long[] gf0;
    private static long[] gf1;
    private static long[] _121665;
    private static long[] D;
    private static long[] D2;
    private static long[] X;
    private static long[] Y;
    private static long[] I;
    private static byte[] sigma;
    private static int[] minusp;
    private static int[] jsK;
    private static long[] L;
    private static Random prng;

    public static void crypto_sign_keypair(byte[] pk, byte[] sk, boolean isSeeded) {
        byte[] d = new byte[64];
        long[][] p = new long[4][16];
        if (!isSeeded) {
            TweetNaCl.randombytes(sk, 32);
        }
        TweetNaCl.crypto_hash(d, sk, 32);
        d[0] = (byte)(d[0] & 0xF8);
        d[31] = (byte)(d[31] & 0x7F);
        d[31] = (byte)(d[31] | 0x40);
        TweetNaCl.scalarbase(p, d, 0);
        TweetNaCl.pack(pk, p);
        for (int i = 0; i < 32; ++i) {
            sk[32 + i] = pk[i];
        }
    }

    public static int crypto_box_keypair(byte[] y, byte[] x, boolean isSeeded) {
        if (!isSeeded) {
            TweetNaCl.randombytes(x, 32);
        }
        return TweetNaCl.crypto_scalarmult_base(y, x);
    }

    public static int crypto_scalarmult_base(byte[] q, byte[] n) {
        return TweetNaCl.crypto_scalarmult(q, n, _9);
    }

    public static byte[] crypto_sign(byte[] message, byte[] secretSigningKey) {
        byte[] signedMessage = new byte[message.length + 64];
        TweetNaCl.crypto_sign(signedMessage, message, message.length, secretSigningKey);
        return signedMessage;
    }

    public static byte[] crypto_sign_open(byte[] signed, byte[] publicSigningKey) {
        byte[] message = new byte[signed.length];
        int res = TweetNaCl.crypto_sign_open(message, signed, signed.length, publicSigningKey);
        if (res != 0) {
            throw new InvalidSignatureException();
        }
        return Arrays.copyOfRange(message, 64, message.length);
    }

    public static byte[] crypto_box(byte[] message, byte[] nonce, byte[] theirPublicBoxingKey, byte[] ourSecretBoxingKey) {
        if (nonce.length != 24) {
            throw new IllegalStateException("Illegal nonce length: " + nonce.length);
        }
        byte[] cipherText = new byte[32 + message.length];
        byte[] paddedMessage = new byte[32 + message.length];
        System.arraycopy(message, 0, paddedMessage, 32, message.length);
        TweetNaCl.crypto_box(cipherText, paddedMessage, paddedMessage.length, nonce, theirPublicBoxingKey, ourSecretBoxingKey);
        return Arrays.copyOfRange(cipherText, 16, cipherText.length);
    }

    public static byte[] crypto_box_open(byte[] cipher, byte[] nonce, byte[] theirPublicBoxingKey, byte[] secretBoxingKey) {
        byte[] paddedCipher = new byte[cipher.length + 16];
        System.arraycopy(cipher, 0, paddedCipher, 16, cipher.length);
        byte[] rawText = new byte[paddedCipher.length];
        int res = TweetNaCl.crypto_box_open(rawText, paddedCipher, paddedCipher.length, nonce, theirPublicBoxingKey, secretBoxingKey);
        if (res != 0) {
            throw new InvalidCipherTextException();
        }
        return Arrays.copyOfRange(rawText, 32, rawText.length);
    }

    public static byte[] secretbox(byte[] mesage, byte[] nonce, byte[] key) {
        byte[] m = new byte[32 + mesage.length];
        byte[] c = new byte[m.length];
        System.arraycopy(mesage, 0, m, 32, mesage.length);
        TweetNaCl.crypto_secretbox(c, m, m.length, nonce, key);
        return Arrays.copyOfRange(c, 16, c.length);
    }

    public static byte[] secretbox_open(byte[] cipher, byte[] nonce, byte[] key) {
        byte[] c = new byte[16 + cipher.length];
        byte[] m = new byte[c.length];
        System.arraycopy(cipher, 0, c, 16, cipher.length);
        if (c.length < 32) {
            throw new IllegalStateException("Cipher too small!");
        }
        if (TweetNaCl.crypto_secretbox_open(m, c, c.length, nonce, key) != 0) {
            throw new IllegalStateException("Invalid encryption!");
        }
        return Arrays.copyOfRange(m, 32, m.length);
    }

    private static int L32(int x, int c) {
        return x << c | x >>> 32 - c;
    }

    public static int ld32(byte[] x, int off) {
        int u = x[off + 3] & 0xFF;
        u = u << 8 | x[off + 2] & 0xFF;
        u = u << 8 | x[off + 1] & 0xFF;
        return u << 8 | x[off + 0] & 0xFF;
    }

    private static void st32(byte[] x, int off, int u) {
        for (int i = 0; i < 4; ++i) {
            x[off + i] = (byte)u;
            u >>= 8;
        }
    }

    private static int vn(byte[] x, int xOff, byte[] y, int n) {
        int d = 0;
        for (int i = 0; i < n; ++i) {
            d |= 0xFF & (x[xOff + i] ^ y[i]);
        }
        return (1 & d - 1 >> 8) - 1;
    }

    private static int crypto_verify_16(byte[] x, int xOff, byte[] y) {
        return TweetNaCl.vn(x, xOff, y, 16);
    }

    private static int crypto_verify_32(byte[] x, byte[] y) {
        return TweetNaCl.vn(x, 0, y, 32);
    }

    private static void core(byte[] out, byte[] in, byte[] k, byte[] c, int h) {
        int i;
        int[] w = new int[16];
        int[] x = new int[16];
        int[] y = new int[16];
        int[] t = new int[4];
        for (i = 0; i < 4; ++i) {
            x[5 * i] = TweetNaCl.ld32(c, 4 * i);
            x[1 + i] = TweetNaCl.ld32(k, 4 * i);
            x[6 + i] = TweetNaCl.ld32(in, 4 * i);
            x[11 + i] = TweetNaCl.ld32(k, 16 + 4 * i);
        }
        for (i = 0; i < 16; ++i) {
            y[i] = x[i];
        }
        for (i = 0; i < 20; ++i) {
            int m;
            for (int j = 0; j < 4; ++j) {
                for (m = 0; m < 4; ++m) {
                    t[m] = x[(5 * j + 4 * m) % 16];
                }
                t[1] = t[1] ^ TweetNaCl.L32(t[0] + t[3], 7);
                t[2] = t[2] ^ TweetNaCl.L32(t[1] + t[0], 9);
                t[3] = t[3] ^ TweetNaCl.L32(t[2] + t[1], 13);
                t[0] = t[0] ^ TweetNaCl.L32(t[3] + t[2], 18);
                for (m = 0; m < 4; ++m) {
                    w[4 * j + (j + m) % 4] = t[m];
                }
            }
            for (m = 0; m < 16; ++m) {
                x[m] = w[m];
            }
        }
        if (h != 0) {
            for (i = 0; i < 16; ++i) {
                int n = i;
                x[n] = x[n] + y[i];
            }
            for (i = 0; i < 4; ++i) {
                int n = 5 * i;
                x[n] = x[n] - TweetNaCl.ld32(c, 4 * i);
                int n2 = 6 + i;
                x[n2] = x[n2] - TweetNaCl.ld32(in, 4 * i);
            }
            for (i = 0; i < 4; ++i) {
                TweetNaCl.st32(out, 4 * i, x[5 * i]);
                TweetNaCl.st32(out, 16 + 4 * i, x[6 + i]);
            }
        } else {
            for (i = 0; i < 16; ++i) {
                TweetNaCl.st32(out, 4 * i, x[i] + y[i]);
            }
        }
    }

    private static int crypto_core_salsa20(byte[] out, byte[] in, byte[] k, byte[] c) {
        TweetNaCl.core(out, in, k, c, 0);
        return 0;
    }

    private static int crypto_core_hsalsa20(byte[] out, byte[] in, byte[] k, byte[] c) {
        TweetNaCl.core(out, in, k, c, 1);
        return 0;
    }

    private static int crypto_stream_salsa20_xor(byte[] c, byte[] m, long b, byte[] n, int nOff, byte[] k) {
        int i;
        byte[] z = new byte[16];
        byte[] x = new byte[64];
        if (b == 0L) {
            return 0;
        }
        for (i = 0; i < 16; ++i) {
            z[i] = 0;
        }
        for (i = 0; i < 8; ++i) {
            z[i] = n[nOff + i];
        }
        int cOff = 0;
        int mOff = 0;
        while (b >= 64L) {
            TweetNaCl.crypto_core_salsa20(x, z, k, sigma);
            for (i = 0; i < 64; ++i) {
                c[cOff + i] = (byte)((m != null ? m[mOff + i] : (byte)0) ^ x[i]);
            }
            int u = 1;
            for (i = 8; i < 16; ++i) {
                z[i] = (byte)(u += 0xFF & z[i]);
                u >>= 8;
            }
            b -= 64L;
            cOff += 64;
            if (m == null) continue;
            mOff += 64;
        }
        if (b != 0L) {
            TweetNaCl.crypto_core_salsa20(x, z, k, sigma);
            i = 0;
            while ((long)i < b) {
                c[cOff + i] = (byte)((m != null ? m[mOff + i] : (byte)0) ^ x[i]);
                ++i;
            }
        }
        return 0;
    }

    private static int crypto_stream_salsa20(byte[] c, long d, byte[] n, int nOff, byte[] k) {
        return TweetNaCl.crypto_stream_salsa20_xor(c, null, d, n, nOff, k);
    }

    private static int crypto_stream(byte[] c, long d, byte[] n, byte[] k) {
        byte[] s = new byte[32];
        TweetNaCl.crypto_core_hsalsa20(s, n, k, sigma);
        return TweetNaCl.crypto_stream_salsa20(c, d, n, 16, s);
    }

    private static int crypto_stream_xor(byte[] c, byte[] m, long d, byte[] n, byte[] k) {
        byte[] s = new byte[32];
        TweetNaCl.crypto_core_hsalsa20(s, n, k, sigma);
        return TweetNaCl.crypto_stream_salsa20_xor(c, m, d, n, 16, s);
    }

    private static void add1305(int[] h, int[] c) {
        int u = 0;
        for (int j = 0; j < 17; ++j) {
            h[j] = (u += h[j] + c[j]) & 0xFF;
            u >>= 8;
        }
    }

    private static int crypto_onetimeauth(byte[] out, int outOff, byte[] m, int mOff, long n, byte[] k) {
        int j;
        int[] x = new int[17];
        int[] r = new int[17];
        int[] h = new int[17];
        int[] c = new int[17];
        int[] g = new int[17];
        for (j = 0; j < 17; ++j) {
            h[j] = 0;
            r[j] = 0;
        }
        for (j = 0; j < 16; ++j) {
            r[j] = 0xFF & k[j];
        }
        r[3] = r[3] & 0xF;
        r[4] = r[4] & 0xFC;
        r[7] = r[7] & 0xF;
        r[8] = r[8] & 0xFC;
        r[11] = r[11] & 0xF;
        r[12] = r[12] & 0xFC;
        r[15] = r[15] & 0xF;
        while (n > 0L) {
            int i;
            for (j = 0; j < 17; ++j) {
                c[j] = 0;
            }
            for (j = 0; j < 16 && (long)j < n; ++j) {
                c[j] = 0xFF & m[mOff + j];
            }
            c[j] = 1;
            mOff += j;
            n -= (long)j;
            TweetNaCl.add1305(h, c);
            for (i = 0; i < 17; ++i) {
                x[i] = 0;
                for (j = 0; j < 17; ++j) {
                    int n2 = i;
                    x[n2] = x[n2] + h[j] * (j <= i ? r[i - j] : 320 * r[i + 17 - j]);
                }
            }
            for (i = 0; i < 17; ++i) {
                h[i] = x[i];
            }
            int u = 0;
            for (j = 0; j < 16; ++j) {
                h[j] = (u += h[j]) & 0xFF;
                u >>= 8;
            }
            h[16] = (u += h[16]) & 3;
            u = 5 * (u >> 2);
            for (j = 0; j < 16; ++j) {
                h[j] = (u += h[j]) & 0xFF;
                u >>= 8;
            }
            h[16] = u += h[16];
        }
        for (j = 0; j < 17; ++j) {
            g[j] = h[j];
        }
        TweetNaCl.add1305(h, minusp);
        int s = -(h[16] >> 7);
        for (j = 0; j < 17; ++j) {
            int n3 = j;
            h[n3] = h[n3] ^ s & (g[j] ^ h[j]);
        }
        for (j = 0; j < 16; ++j) {
            c[j] = 0xFF & k[j + 16];
        }
        c[16] = 0;
        TweetNaCl.add1305(h, c);
        for (j = 0; j < 16; ++j) {
            out[outOff + j] = (byte)h[j];
        }
        return 0;
    }

    private static int crypto_onetimeauth_verify(byte[] h, int hOff, byte[] m, int mOff, long n, byte[] k) {
        byte[] x = new byte[16];
        TweetNaCl.crypto_onetimeauth(x, 0, m, mOff, n, k);
        return TweetNaCl.crypto_verify_16(h, hOff, x);
    }

    private static int crypto_secretbox(byte[] c, byte[] m, long d, byte[] n, byte[] k) {
        if (d < 32L) {
            return -1;
        }
        TweetNaCl.crypto_stream_xor(c, m, d, n, k);
        TweetNaCl.crypto_onetimeauth(c, 16, c, 32, d - 32L, c);
        for (int i = 0; i < 16; ++i) {
            c[i] = 0;
        }
        return 0;
    }

    private static int crypto_secretbox_open(byte[] m, byte[] c, long d, byte[] n, byte[] k) {
        byte[] x = new byte[32];
        if (d < 32L) {
            return -1;
        }
        TweetNaCl.crypto_stream(x, 32L, n, k);
        if (TweetNaCl.crypto_onetimeauth_verify(c, 16, c, 32, d - 32L, x) != 0) {
            return -1;
        }
        TweetNaCl.crypto_stream_xor(m, c, d, n, k);
        for (int i = 0; i < 32; ++i) {
            m[i] = 0;
        }
        return 0;
    }

    private static void set25519(long[] r, long[] a) {
        for (int i = 0; i < 16; ++i) {
            r[i] = a[i];
        }
    }

    private static void car25519(long[] o, int oOff) {
        for (int i = 0; i < 16; ++i) {
            int n = oOff + i;
            o[n] = o[n] + 65536L;
            long c = o[oOff + i] >> 16;
            int n2 = oOff + (i + 1) * (i < 15 ? 1 : 0);
            o[n2] = o[n2] + (c - 1L + 37L * (c - 1L) * (long)(i == 15 ? 1 : 0));
            int n3 = oOff + i;
            o[n3] = o[n3] - (c << 16);
        }
    }

    private static void sel25519(long[] p, long[] q, int b) {
        long c = ~(b - 1);
        int i = 0;
        while (i < 16) {
            long t = c & (p[i] ^ q[i]);
            int n = i;
            p[n] = p[n] ^ t;
            int n2 = i++;
            q[n2] = q[n2] ^ t;
        }
    }

    private static void pack25519(byte[] o, long[] n, int nOff) {
        int i;
        long[] m = new long[16];
        long[] t = new long[16];
        for (i = 0; i < 16; ++i) {
            t[i] = n[nOff + i];
        }
        TweetNaCl.car25519(t, 0);
        TweetNaCl.car25519(t, 0);
        TweetNaCl.car25519(t, 0);
        for (int j = 0; j < 2; ++j) {
            m[0] = t[0] - 65517L;
            for (i = 1; i < 15; ++i) {
                m[i] = t[i] - 65535L - (m[i - 1] >> 16 & 1L);
                int n2 = i - 1;
                m[n2] = m[n2] & 0xFFFFL;
            }
            m[15] = t[15] - 32767L - (m[14] >> 16 & 1L);
            int b = (int)(m[15] >> 16 & 1L);
            m[14] = m[14] & 0xFFFFL;
            TweetNaCl.sel25519(t, m, 1 - b);
        }
        for (i = 0; i < 16; ++i) {
            o[2 * i] = (byte)t[i];
            o[2 * i + 1] = (byte)(t[i] >> 8);
        }
    }

    private static int neq25519(long[] a, long[] b) {
        byte[] c = new byte[32];
        byte[] d = new byte[32];
        TweetNaCl.pack25519(c, a, 0);
        TweetNaCl.pack25519(d, b, 0);
        return TweetNaCl.crypto_verify_32(c, d);
    }

    private static byte par25519(long[] a) {
        byte[] d = new byte[32];
        TweetNaCl.pack25519(d, a, 0);
        return (byte)(d[0] & 1);
    }

    private static void unpack25519(long[] o, byte[] n) {
        for (int i = 0; i < 16; ++i) {
            o[i] = (long)(0xFF & n[2 * i]) + ((0xFFL & (long)n[2 * i + 1]) << 8);
        }
        o[15] = o[15] & 0x7FFFL;
    }

    private static void A(long[] o, long[] a, long[] b) {
        for (int i = 0; i < 16; ++i) {
            o[i] = a[i] + b[i];
        }
    }

    private static void Z(long[] o, long[] a, long[] b) {
        for (int i = 0; i < 16; ++i) {
            o[i] = a[i] - b[i];
        }
    }

    private static void M(long[] o, int oOff, long[] a, int aOff, long[] b, int bOff) {
        int i;
        long[] t = new long[31];
        for (i = 0; i < 31; ++i) {
            t[i] = 0L;
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n = i + j;
                t[n] = t[n] + a[aOff + i] * b[bOff + j];
            }
        }
        for (i = 0; i < 15; ++i) {
            int n = i;
            t[n] = t[n] + 38L * t[i + 16];
        }
        for (i = 0; i < 16; ++i) {
            o[oOff + i] = t[i];
        }
        TweetNaCl.car25519(o, oOff);
        TweetNaCl.car25519(o, oOff);
    }

    private static void S(long[] o, long[] a) {
        TweetNaCl.M(o, 0, a, 0, a, 0);
    }

    private static void inv25519(long[] o, int oOff, long[] i, int iOff) {
        int a;
        long[] c = new long[16];
        for (a = 0; a < 16; ++a) {
            c[a] = i[iOff + a];
        }
        for (a = 253; a >= 0; --a) {
            TweetNaCl.S(c, c);
            if (a == 2 || a == 4) continue;
            TweetNaCl.M(c, 0, c, 0, i, iOff);
        }
        for (a = 0; a < 16; ++a) {
            o[oOff + a] = c[a];
        }
    }

    private static void pow2523(long[] o, long[] i) {
        int a;
        long[] c = new long[16];
        for (a = 0; a < 16; ++a) {
            c[a] = i[a];
        }
        for (a = 250; a >= 0; --a) {
            TweetNaCl.S(c, c);
            if (a == 1) continue;
            TweetNaCl.M(c, 0, c, 0, i, 0);
        }
        for (a = 0; a < 16; ++a) {
            o[a] = c[a];
        }
    }

    private static int crypto_scalarmult(byte[] q, byte[] n, byte[] p) {
        int i;
        byte[] z = new byte[32];
        long[] x = new long[80];
        long[] a = new long[16];
        long[] b = new long[16];
        long[] c = new long[16];
        long[] d = new long[16];
        long[] e = new long[16];
        long[] f = new long[16];
        for (i = 0; i < 31; ++i) {
            z[i] = n[i];
        }
        z[31] = (byte)(n[31] & 0x7F | 0x40);
        z[0] = (byte)(z[0] & 0xF8);
        TweetNaCl.unpack25519(x, p);
        for (i = 0; i < 16; ++i) {
            b[i] = x[i];
            c[i] = 0L;
            a[i] = 0L;
            d[i] = 0L;
        }
        d[0] = 1L;
        a[0] = 1L;
        for (i = 254; i >= 0; --i) {
            int r = (0xFF & z[i >> 3]) >> (i & 7) & 1;
            TweetNaCl.sel25519(a, b, r);
            TweetNaCl.sel25519(c, d, r);
            TweetNaCl.A(e, a, c);
            TweetNaCl.Z(a, a, c);
            TweetNaCl.A(c, b, d);
            TweetNaCl.Z(b, b, d);
            TweetNaCl.S(d, e);
            TweetNaCl.S(f, a);
            TweetNaCl.M(a, 0, c, 0, a, 0);
            TweetNaCl.M(c, 0, b, 0, e, 0);
            TweetNaCl.A(e, a, c);
            TweetNaCl.Z(a, a, c);
            TweetNaCl.S(b, a);
            TweetNaCl.Z(c, d, f);
            TweetNaCl.M(a, 0, c, 0, _121665, 0);
            TweetNaCl.A(a, a, d);
            TweetNaCl.M(c, 0, c, 0, a, 0);
            TweetNaCl.M(a, 0, d, 0, f, 0);
            TweetNaCl.M(d, 0, b, 0, x, 0);
            TweetNaCl.S(b, e);
            TweetNaCl.sel25519(a, b, r);
            TweetNaCl.sel25519(c, d, r);
        }
        for (i = 0; i < 16; ++i) {
            x[i + 16] = a[i];
            x[i + 32] = c[i];
            x[i + 48] = b[i];
            x[i + 64] = d[i];
        }
        TweetNaCl.inv25519(x, 32, x, 32);
        TweetNaCl.M(x, 16, x, 16, x, 32);
        TweetNaCl.pack25519(q, x, 16);
        return 0;
    }

    private static int crypto_box_beforenm(byte[] k, byte[] y, byte[] x) {
        byte[] s = new byte[32];
        TweetNaCl.crypto_scalarmult(s, x, y);
        return TweetNaCl.crypto_core_hsalsa20(k, _0, s, sigma);
    }

    private static int crypto_box_afternm(byte[] c, byte[] m, long d, byte[] n, byte[] k) {
        return TweetNaCl.crypto_secretbox(c, m, d, n, k);
    }

    private static int crypto_box_open_afternm(byte[] m, byte[] c, long d, byte[] n, byte[] k) {
        return TweetNaCl.crypto_secretbox_open(m, c, d, n, k);
    }

    private static int crypto_box(byte[] c, byte[] m, long d, byte[] nonce, byte[] theirPublicBoxingKey, byte[] ourSecretBoxingKey) {
        byte[] k = new byte[32];
        TweetNaCl.crypto_box_beforenm(k, theirPublicBoxingKey, ourSecretBoxingKey);
        return TweetNaCl.crypto_box_afternm(c, m, d, nonce, k);
    }

    private static int crypto_box_open(byte[] m, byte[] c, long d, byte[] n, byte[] y, byte[] x) {
        byte[] k = new byte[32];
        TweetNaCl.crypto_box_beforenm(k, y, x);
        return TweetNaCl.crypto_box_open_afternm(m, c, d, n, k);
    }

    private static int crypto_hash(byte[] out, byte[] m, int n) {
        int i;
        int[] hh = new int[8];
        int[] hl = new int[8];
        byte[] x = new byte[256];
        int b = n;
        hh[0] = 1779033703;
        hh[1] = -1150833019;
        hh[2] = 1013904242;
        hh[3] = -1521486534;
        hh[4] = 1359893119;
        hh[5] = -1694144372;
        hh[6] = 528734635;
        hh[7] = 1541459225;
        hl[0] = -205731576;
        hl[1] = -2067093701;
        hl[2] = -23791573;
        hl[3] = 1595750129;
        hl[4] = -1377402159;
        hl[5] = 725511199;
        hl[6] = -79577749;
        hl[7] = 327033209;
        TweetNaCl.crypto_hashblocks_hl(hh, hl, m, n);
        n %= 128;
        for (i = 0; i < n; ++i) {
            x[i] = m[b - n + i];
        }
        x[n] = -128;
        n = 256 - 128 * (n < 112 ? 1 : 0);
        x[n - 9] = 0;
        TweetNaCl.jsts64(x, n - 8, b / 0x20000000, b << 3);
        TweetNaCl.crypto_hashblocks_hl(hh, hl, x, n);
        for (i = 0; i < 8; ++i) {
            TweetNaCl.jsts64(out, 8 * i, hh[i], hl[i]);
        }
        return 0;
    }

    private static void jsts64(byte[] x, int i, int h, int l) {
        x[i] = (byte)(h >> 24);
        x[i + 1] = (byte)(h >> 16);
        x[i + 2] = (byte)(h >> 8);
        x[i + 3] = (byte)h;
        x[i + 4] = (byte)(l >> 24);
        x[i + 5] = (byte)(l >> 16);
        x[i + 6] = (byte)(l >> 8);
        x[i + 7] = (byte)l;
    }

    private static int crypto_hashblocks_hl(int[] hh, int[] hl, byte[] m, int n) {
        int[] wh = new int[16];
        int[] wl = new int[16];
        int ah0 = hh[0];
        int ah1 = hh[1];
        int ah2 = hh[2];
        int ah3 = hh[3];
        int ah4 = hh[4];
        int ah5 = hh[5];
        int ah6 = hh[6];
        int ah7 = hh[7];
        int al0 = hl[0];
        int al1 = hl[1];
        int al2 = hl[2];
        int al3 = hl[3];
        int al4 = hl[4];
        int al5 = hl[5];
        int al6 = hl[6];
        int al7 = hl[7];
        int pos = 0;
        while (n >= 128) {
            int d;
            int c;
            int b;
            int a;
            int l;
            int h;
            int j;
            int i;
            for (i = 0; i < 16; ++i) {
                j = 8 * i + pos;
                wh[i] = (m[j + 0] & 0xFF) << 24 | (m[j + 1] & 0xFF) << 16 | (m[j + 2] & 0xFF) << 8 | m[j + 3] & 0xFF;
                wl[i] = (m[j + 4] & 0xFF) << 24 | (m[j + 5] & 0xFF) << 16 | (m[j + 6] & 0xFF) << 8 | m[j + 7] & 0xFF;
            }
            for (i = 0; i < 80; ++i) {
                int bh0 = ah0;
                int bh1 = ah1;
                int bh2 = ah2;
                int bh3 = ah3;
                int bh4 = ah4;
                int bh5 = ah5;
                int bh6 = ah6;
                int bh7 = ah7;
                int bl0 = al0;
                int bl1 = al1;
                int bl2 = al2;
                int bl3 = al3;
                int bl4 = al4;
                int bl5 = al5;
                int bl6 = al6;
                int bl7 = al7;
                h = ah7;
                l = al7;
                a = l & 0xFFFF;
                b = l >>> 16;
                c = h & 0xFFFF;
                d = h >>> 16;
                h = (ah4 >>> 14 | al4 << 18) ^ (ah4 >>> 18 | al4 << 14) ^ (al4 >>> 9 | ah4 << 23);
                l = (al4 >>> 14 | ah4 << 18) ^ (al4 >>> 18 | ah4 << 14) ^ (ah4 >>> 9 | al4 << 23);
                a += l & 0xFFFF;
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                h = ah4 & ah5 ^ ~ah4 & ah6;
                l = al4 & al5 ^ ~al4 & al6;
                a += l & 0xFFFF;
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                h = jsK[i * 2];
                l = jsK[i * 2 + 1];
                a += l & 0xFFFF;
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                h = wh[i % 16];
                l = wl[i % 16];
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                int th = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
                int tl = a & 0xFFFF | b << 16;
                h = th;
                l = tl;
                a = l & 0xFFFF;
                b = l >>> 16;
                c = h & 0xFFFF;
                d = h >>> 16;
                h = (ah0 >>> 28 | al0 << 4) ^ (al0 >>> 2 | ah0 << 30) ^ (al0 >>> 7 | ah0 << 25);
                l = (al0 >>> 28 | ah0 << 4) ^ (ah0 >>> 2 | al0 << 30) ^ (ah0 >>> 7 | al0 << 25);
                a += l & 0xFFFF;
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                h = ah0 & ah1 ^ ah0 & ah2 ^ ah1 & ah2;
                l = al0 & al1 ^ al0 & al2 ^ al1 & al2;
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                bh7 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
                bl7 = a & 0xFFFF | b << 16;
                h = bh3;
                l = bl3;
                a = l & 0xFFFF;
                b = l >>> 16;
                c = h & 0xFFFF;
                d = h >>> 16;
                h = th;
                l = tl;
                b += l >>> 16;
                c += h & 0xFFFF;
                d += h >>> 16;
                bh3 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
                bl3 = a & 0xFFFF | b << 16;
                ah1 = bh0;
                ah2 = bh1;
                ah3 = bh2;
                ah4 = bh3;
                ah5 = bh4;
                ah6 = bh5;
                ah7 = bh6;
                ah0 = bh7;
                al1 = bl0;
                al2 = bl1;
                al3 = bl2;
                al4 = bl3;
                al5 = bl4;
                al6 = bl5;
                al7 = bl6;
                al0 = bl7;
                if (i % 16 != 15) continue;
                for (j = 0; j < 16; ++j) {
                    h = wh[j];
                    l = wl[j];
                    a = l & 0xFFFF;
                    b = l >>> 16;
                    c = h & 0xFFFF;
                    d = h >>> 16;
                    h = wh[(j + 9) % 16];
                    l = wl[(j + 9) % 16];
                    a += l & 0xFFFF;
                    b += l >>> 16;
                    c += h & 0xFFFF;
                    d += h >>> 16;
                    th = wh[(j + 1) % 16];
                    tl = wl[(j + 1) % 16];
                    h = (th >>> 1 | tl << 31) ^ (th >>> 8 | tl << 24) ^ th >>> 7;
                    l = (tl >>> 1 | th << 31) ^ (tl >>> 8 | th << 24) ^ (tl >>> 7 | th << 25);
                    a += l & 0xFFFF;
                    b += l >>> 16;
                    c += h & 0xFFFF;
                    d += h >>> 16;
                    th = wh[(j + 14) % 16];
                    tl = wl[(j + 14) % 16];
                    h = (th >>> 19 | tl << 13) ^ (tl >>> 29 | th << 3) ^ th >>> 6;
                    l = (tl >>> 19 | th << 13) ^ (th >>> 29 | tl << 3) ^ (tl >>> 6 | th << 26);
                    b += l >>> 16;
                    c += h & 0xFFFF;
                    d += h >>> 16;
                    wh[j] = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
                    wl[j] = a & 0xFFFF | b << 16;
                }
            }
            h = ah0;
            l = al0;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[0];
            l = hl[0];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[0] = ah0 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[0] = al0 = a & 0xFFFF | b << 16;
            h = ah1;
            l = al1;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[1];
            l = hl[1];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[1] = ah1 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[1] = al1 = a & 0xFFFF | b << 16;
            h = ah2;
            l = al2;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[2];
            l = hl[2];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[2] = ah2 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[2] = al2 = a & 0xFFFF | b << 16;
            h = ah3;
            l = al3;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[3];
            l = hl[3];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[3] = ah3 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[3] = al3 = a & 0xFFFF | b << 16;
            h = ah4;
            l = al4;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[4];
            l = hl[4];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[4] = ah4 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[4] = al4 = a & 0xFFFF | b << 16;
            h = ah5;
            l = al5;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[5];
            l = hl[5];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[5] = ah5 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[5] = al5 = a & 0xFFFF | b << 16;
            h = ah6;
            l = al6;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[6];
            l = hl[6];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[6] = ah6 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[6] = al6 = a & 0xFFFF | b << 16;
            h = ah7;
            l = al7;
            a = l & 0xFFFF;
            b = l >>> 16;
            c = h & 0xFFFF;
            d = h >>> 16;
            h = hh[7];
            l = hl[7];
            b += l >>> 16;
            c += h & 0xFFFF;
            d += h >>> 16;
            hh[7] = ah7 = c & 0xFFFF | (d += (c += (b += (a += l & 0xFFFF) >>> 16) >>> 16) >>> 16) << 16;
            hl[7] = al7 = a & 0xFFFF | b << 16;
            pos += 128;
            n -= 128;
        }
        return n;
    }

    private static void add(long[][] p, long[][] q) {
        long[] a = new long[16];
        long[] b = new long[16];
        long[] c = new long[16];
        long[] d = new long[16];
        long[] t = new long[16];
        long[] e = new long[16];
        long[] f = new long[16];
        long[] g = new long[16];
        long[] h = new long[16];
        TweetNaCl.Z(a, p[1], p[0]);
        TweetNaCl.Z(t, q[1], q[0]);
        TweetNaCl.M(a, 0, a, 0, t, 0);
        TweetNaCl.A(b, p[0], p[1]);
        TweetNaCl.A(t, q[0], q[1]);
        TweetNaCl.M(b, 0, b, 0, t, 0);
        TweetNaCl.M(c, 0, p[3], 0, q[3], 0);
        TweetNaCl.M(c, 0, c, 0, D2, 0);
        TweetNaCl.M(d, 0, p[2], 0, q[2], 0);
        TweetNaCl.A(d, d, d);
        TweetNaCl.Z(e, b, a);
        TweetNaCl.Z(f, d, c);
        TweetNaCl.A(g, d, c);
        TweetNaCl.A(h, b, a);
        TweetNaCl.M(p[0], 0, e, 0, f, 0);
        TweetNaCl.M(p[1], 0, h, 0, g, 0);
        TweetNaCl.M(p[2], 0, g, 0, f, 0);
        TweetNaCl.M(p[3], 0, e, 0, h, 0);
    }

    private static void cswap(long[][] p, long[][] q, byte b) {
        for (int i = 0; i < 4; ++i) {
            TweetNaCl.sel25519(p[i], q[i], b & 0xFF);
        }
    }

    private static void pack(byte[] r, long[][] p) {
        long[] tx = new long[16];
        long[] ty = new long[16];
        long[] zi = new long[16];
        TweetNaCl.inv25519(zi, 0, p[2], 0);
        TweetNaCl.M(tx, 0, p[0], 0, zi, 0);
        TweetNaCl.M(ty, 0, p[1], 0, zi, 0);
        TweetNaCl.pack25519(r, ty, 0);
        r[31] = (byte)(r[31] ^ TweetNaCl.par25519(tx) << 7);
    }

    private static void scalarmult(long[][] p, long[][] q, byte[] s, int sOff) {
        TweetNaCl.set25519(p[0], gf0);
        TweetNaCl.set25519(p[1], gf1);
        TweetNaCl.set25519(p[2], gf1);
        TweetNaCl.set25519(p[3], gf0);
        for (int i = 255; i >= 0; --i) {
            byte b = (byte)((0xFF & s[sOff + i / 8]) >> (i & 7) & 1);
            TweetNaCl.cswap(p, q, b);
            TweetNaCl.add(q, p);
            TweetNaCl.add(p, p);
            TweetNaCl.cswap(p, q, b);
        }
    }

    private static void scalarbase(long[][] p, byte[] s, int sOff) {
        long[][] q = new long[4][16];
        TweetNaCl.set25519(q[0], X);
        TweetNaCl.set25519(q[1], Y);
        TweetNaCl.set25519(q[2], gf1);
        TweetNaCl.M(q[3], 0, X, 0, Y, 0);
        TweetNaCl.scalarmult(p, q, s, sOff);
    }

    private static void modL(byte[] r, int rOff, long[] x) {
        int j;
        long carry;
        int i;
        for (i = 63; i >= 32; --i) {
            carry = 0L;
            j = i - 32;
            while (j < i - 12) {
                int n = j;
                x[n] = x[n] + (carry - 16L * x[i] * L[j - (i - 32)]);
                carry = x[j] + 128L >> 8;
                int n2 = j++;
                x[n2] = x[n2] - (carry << 8);
            }
            int n = j;
            x[n] = x[n] + carry;
            x[i] = 0L;
        }
        carry = 0L;
        j = 0;
        while (j < 32) {
            int n = j;
            x[n] = x[n] + (carry - (x[31] >> 4) * L[j]);
            carry = x[j] >> 8;
            int n3 = j++;
            x[n3] = x[n3] & 0xFFL;
        }
        for (j = 0; j < 32; ++j) {
            int n = j;
            x[n] = x[n] - carry * L[j];
        }
        for (i = 0; i < 32; ++i) {
            int n = i + 1;
            x[n] = x[n] + (x[i] >> 8);
            r[rOff + i] = (byte)(x[i] & 0xFFL);
        }
    }

    private static void reduce(byte[] r) {
        int i;
        long[] x = new long[64];
        for (i = 0; i < 64; ++i) {
            x[i] = 0xFF & r[i];
        }
        for (i = 0; i < 64; ++i) {
            r[i] = 0;
        }
        TweetNaCl.modL(r, 0, x);
    }

    private static int crypto_sign(byte[] sm, byte[] m, int n, byte[] sk) {
        int i;
        byte[] d = new byte[64];
        byte[] h = new byte[64];
        byte[] r = new byte[64];
        long[] x = new long[64];
        long[][] p = new long[4][16];
        TweetNaCl.crypto_hash(d, sk, 32);
        d[0] = (byte)(d[0] & 0xF8);
        d[31] = (byte)(d[31] & 0x7F);
        d[31] = (byte)(d[31] | 0x40);
        for (i = 0; i < n; ++i) {
            sm[64 + i] = m[i];
        }
        for (i = 0; i < 32; ++i) {
            sm[32 + i] = d[32 + i];
        }
        TweetNaCl.crypto_hash(r, Arrays.copyOfRange(sm, 32, sm.length), n + 32);
        TweetNaCl.reduce(r);
        TweetNaCl.scalarbase(p, r, 0);
        TweetNaCl.pack(sm, p);
        for (i = 0; i < 32; ++i) {
            sm[i + 32] = sk[i + 32];
        }
        TweetNaCl.crypto_hash(h, sm, n + 64);
        TweetNaCl.reduce(h);
        for (i = 0; i < 64; ++i) {
            x[i] = 0L;
        }
        for (i = 0; i < 32; ++i) {
            x[i] = 0xFF & r[i];
        }
        for (i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int n2 = i + j;
                x[n2] = x[n2] + (long)((0xFF & h[i]) * (0xFF & d[j]));
            }
        }
        TweetNaCl.modL(sm, 32, x);
        return 0;
    }

    private static int unpackneg(long[][] r, byte[] p) {
        long[] t = new long[16];
        long[] chk = new long[16];
        long[] num = new long[16];
        long[] den = new long[16];
        long[] den2 = new long[16];
        long[] den4 = new long[16];
        long[] den6 = new long[16];
        TweetNaCl.set25519(r[2], gf1);
        TweetNaCl.unpack25519(r[1], p);
        TweetNaCl.S(num, r[1]);
        TweetNaCl.M(den, 0, num, 0, D, 0);
        TweetNaCl.Z(num, num, r[2]);
        TweetNaCl.A(den, r[2], den);
        TweetNaCl.S(den2, den);
        TweetNaCl.S(den4, den2);
        TweetNaCl.M(den6, 0, den4, 0, den2, 0);
        TweetNaCl.M(t, 0, den6, 0, num, 0);
        TweetNaCl.M(t, 0, t, 0, den, 0);
        TweetNaCl.pow2523(t, t);
        TweetNaCl.M(t, 0, t, 0, num, 0);
        TweetNaCl.M(t, 0, t, 0, den, 0);
        TweetNaCl.M(t, 0, t, 0, den, 0);
        TweetNaCl.M(r[0], 0, t, 0, den, 0);
        TweetNaCl.S(chk, r[0]);
        TweetNaCl.M(chk, 0, chk, 0, den, 0);
        if (TweetNaCl.neq25519(chk, num) != 0) {
            TweetNaCl.M(r[0], 0, r[0], 0, I, 0);
        }
        TweetNaCl.S(chk, r[0]);
        TweetNaCl.M(chk, 0, chk, 0, den, 0);
        if (TweetNaCl.neq25519(chk, num) != 0) {
            return -1;
        }
        if (TweetNaCl.par25519(r[0]) == (0xFF & p[31]) >> 7) {
            TweetNaCl.Z(r[0], gf0, r[0]);
        }
        TweetNaCl.M(r[3], 0, r[0], 0, r[1], 0);
        return 0;
    }

    private static int crypto_sign_open(byte[] m, byte[] sm, int n, byte[] pk) {
        int i;
        byte[] t = new byte[32];
        byte[] h = new byte[64];
        long[][] p = new long[4][16];
        long[][] q = new long[4][16];
        if (n < 64) {
            return -1;
        }
        if (TweetNaCl.unpackneg(q, pk) != 0) {
            return -1;
        }
        for (i = 0; i < n; ++i) {
            m[i] = sm[i];
        }
        for (i = 0; i < 32; ++i) {
            m[i + 32] = pk[i];
        }
        TweetNaCl.crypto_hash(h, m, n);
        TweetNaCl.reduce(h);
        TweetNaCl.scalarmult(p, q, h, 0);
        TweetNaCl.scalarbase(q, sm, 32);
        TweetNaCl.add(p, q);
        TweetNaCl.pack(t, p);
        n -= 64;
        if (TweetNaCl.crypto_verify_32(sm, t) != 0) {
            for (i = 0; i < n; ++i) {
                m[i] = 0;
            }
            return -1;
        }
        for (i = 0; i < n; ++i) {
            m[64 + i] = sm[i + 64];
        }
        return 0;
    }

    private static SecureRandom getStrongCSPRNG() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void randombytes(byte[] b, int len) {
        byte[] r = new byte[len];
        prng.nextBytes(r);
        System.arraycopy(r, 0, b, 0, len);
    }

    static {
        TweetNaCl._9[0] = 9;
        gf0 = new long[16];
        gf1 = new long[16];
        TweetNaCl.gf1[0] = 1L;
        _121665 = new long[16];
        TweetNaCl._121665[0] = 56129L;
        TweetNaCl._121665[1] = 1L;
        D = new long[]{30883L, 4953L, 19914L, 30187L, 55467L, 16705L, 2637L, 112L, 59544L, 30585L, 16505L, 36039L, 65139L, 11119L, 27886L, 20995L};
        D2 = new long[]{61785L, 9906L, 39828L, 60374L, 45398L, 33411L, 5274L, 224L, 53552L, 61171L, 33010L, 6542L, 64743L, 22239L, 55772L, 9222L};
        X = new long[]{54554L, 36645L, 11616L, 51542L, 42930L, 38181L, 51040L, 26924L, 56412L, 64982L, 57905L, 49316L, 21502L, 52590L, 14035L, 8553L};
        Y = new long[]{26200L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L};
        I = new long[]{41136L, 18958L, 6951L, 50414L, 58488L, 44335L, 6150L, 12099L, 55207L, 15867L, 153L, 11085L, 57099L, 20417L, 9344L, 11139L};
        sigma = new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107};
        minusp = new int[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252};
        jsK = new int[]{1116352408, -685199838, 1899447441, 602891725, -1245643825, -330482897, -373957723, -2121671748, 961987163, -213338824, 1508970993, -1241133031, -1841331548, -1357295717, -1424204075, -630357736, -670586216, -1560083902, 310598401, 1164996542, 607225278, 1323610764, 1426881987, -704662302, 1925078388, -226784913, -2132889090, 991336113, -1680079193, 633803317, -1046744716, -815192428, -459576895, -1628353838, -272742522, 944711139, 264347078, -1953704523, 604807628, 2007800933, 770255983, 1495990901, 1249150122, 1856431235, 1555081692, -1119749164, 1996064986, -2096016459, -1740746414, -295247957, -1473132947, 766784016, -1341970488, -1728372417, -1084653625, -1091629340, -958395405, 1034457026, -710438585, -1828018395, 113926993, -536640913, 338241895, 168717936, 666307205, 1188179964, 773529912, 1546045734, 1294757372, 1522805485, 1396182291, -1651133473, 1695183700, -1951439906, 1986661051, 1014477480, -2117940946, 1206759142, -1838011259, 344077627, -1564481375, 1290863460, -1474664885, -1136513023, -1035236496, -789014639, -949202525, 106217008, -778901479, -688958952, -694614492, 1432725776, -200395387, 1467031594, 275423344, 851169720, 430227734, -1194143544, 506948616, 1363258195, 659060556, -544281703, 883997877, -509917016, 958139571, -976659869, 1322822218, -482243893, 1537002063, 2003034995, 1747873779, -692930397, 1955562222, 1575990012, 2024104815, 1125592928, -2067236844, -1578062990, -1933114872, 442776044, -1866530822, 593698344, -1538233109, -561857047, -1090935817, -1295615723, -965641998, -479046869, -903397682, -366583396, -779700025, 566280711, -354779690, -840897762, -176337025, -294727304, 116418474, 1914138554, 174292421, -1563912026, 289380356, -1090974290, 460393269, 320620315, 685471733, 587496836, 852142971, 1086792851, 1017036298, 365543100, 1126000580, -1676669620, 1288033470, -885112138, 1501505948, -60457430, 1607167915, 987167468, 1816402316, 1246189591};
        L = new long[]{237L, 211L, 245L, 92L, 26L, 99L, 18L, 88L, 214L, 156L, 247L, 162L, 222L, 249L, 222L, 20L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 16L};
        prng = TweetNaCl.getStrongCSPRNG();
    }

    public static class InvalidCipherTextException
    extends RuntimeException {
    }

    public static class InvalidSignatureException
    extends RuntimeException {
    }
}

