/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.text.ParseException;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastDateFormat {
    private final TimeZone zone;
    private final FormatSpec defaultFormatSpec;
    private volatile Status status = new Status();
    private static final long MILLISECONDS_IN_FOUR_CENTURIES = 12622780800000L;
    static final int DAYS_FROM_YEAR_ZERO_TO_1970 = 719528;
    private static final long DAYS_IN_FOUR_CENTURIES = 146097L;
    private static final int DAYS_IN_CENTURY = 36524;
    private static final int DAYS_IN_FOUR_YEARS = 1461;
    private static final String dashDateRegex = "([-+])?+([0-9]{4,}+)-([01][0-9])(?:-?+([0123][0-9])";
    private static final String noDashDateRegex = "([-+])?+([0-9]{4,})([01][0-9])([0123][0-9])";
    private static final String msPointRegex = "[.,]([0-9]{1,4}+)[0-9]*+";
    private static final String msMaybePointRegex = "[.,]?+([0-9]{1,4}+)[0-9]*+";
    private static final String timeRegex = "([012][0-9])(?::?+([0-5][0-9])(?::?+([0-6][0-9])(?:[.,]?+([0-9]{1,4}+)[0-9]*+)?+)?+)?+";
    private static final String zoneRegex = "(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+";
    private static final String dashesRegex = "\\s*+([-+])?+([0-9]{4,}+)-([01][0-9])(?:-?+([0123][0-9])(?:\\s*+T?+\\s*+([012][0-9])(?::?+([0-5][0-9])(?::?+([0-6][0-9])(?:[.,]?+([0-9]{1,4}+)[0-9]*+)?+)?+)?+)?+)?+\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+";
    private static final Pattern dashesPattern = Pattern.compile("\\s*+([-+])?+([0-9]{4,}+)-([01][0-9])(?:-?+([0123][0-9])(?:\\s*+T?+\\s*+([012][0-9])(?::?+([0-5][0-9])(?::?+([0-6][0-9])(?:[.,]?+([0-9]{1,4}+)[0-9]*+)?+)?+)?+)?+)?+\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+");
    private static final String noDashesAndTimeRegex = "\\s*+([-+])?+([0-9]{4,})([01][0-9])([0123][0-9])(?:\\s*+T?+\\s*+([012][0-9])(?::?+([0-5][0-9])(?::?+([0-6][0-9])(?:[.,]?+([0-9]{1,4}+)[0-9]*+)?+)?+)?+)?+\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+";
    private static final Pattern noDashesAndTimePattern = Pattern.compile("\\s*+([-+])?+([0-9]{4,})([01][0-9])([0123][0-9])(?:\\s*+T?+\\s*+([012][0-9])(?::?+([0-5][0-9])(?::?+([0-6][0-9])(?:[.,]?+([0-9]{1,4}+)[0-9]*+)?+)?+)?+)?+\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+");
    private static final String allDigitsWithPointRegex = "\\s*+([-+])?+([0-9]{4,})([01][0-9])([0123][0-9])([012][0-9])([0-5][0-9])([0-6][0-9])[.,]([0-9]{1,4}+)[0-9]*+\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+";
    private static final Pattern allDigitsWithPointPattern = Pattern.compile("\\s*+([-+])?+([0-9]{4,})([01][0-9])([0123][0-9])([012][0-9])([0-5][0-9])([0-6][0-9])[.,]([0-9]{1,4}+)[0-9]*+\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+");
    private static final String allDigitsRegex = "\\s*+([-+])?+([0-9]*+)\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+";
    private static final Pattern allDigitsPattern = Pattern.compile("\\s*+([-+])?+([0-9]*+)\\s*+(?:(Z)|(?:([-+])([012][0-9])(?::?+([0-5][0-9]))?+))?+\\s*+");

    private static String pad2(int s) {
        if (s >= 10) {
            return String.valueOf(s);
        }
        return "0" + s;
    }

    private static String pad3(int s) {
        if (s >= 100) {
            return String.valueOf(s);
        }
        if (s >= 10) {
            return "0" + s;
        }
        return "00" + s;
    }

    private static String pad4(int s) {
        if (s >= 1000) {
            return String.valueOf(s);
        }
        if (s >= 100) {
            return "0" + s;
        }
        if (s >= 10) {
            return "00" + s;
        }
        if (s >= 0) {
            return "000" + s;
        }
        if (s > -10) {
            return "-000" + -s;
        }
        if (s > -100) {
            return "-00" + -s;
        }
        if (s > -1000) {
            return "-0" + -s;
        }
        return "-" + -s;
    }

    private static Status getStatus(Date date) {
        Status newStatus = new Status();
        newStatus.yearString = FastDateFormat.pad4(date.year);
        newStatus.monthString = FastDateFormat.pad2(date.month);
        newStatus.dayString = FastDateFormat.pad2(date.day);
        newStatus.hourString = FastDateFormat.pad2(date.hour);
        newStatus.minuteString = FastDateFormat.pad2(date.minute);
        newStatus.isZ = date.zoneHour == 0 && date.zoneMinute == 0;
        newStatus.zoneHour = (date.negativeZone ? "-" : "+") + FastDateFormat.pad2(date.zoneHour);
        newStatus.zoneMinute = FastDateFormat.pad2(date.zoneMinute);
        return newStatus;
    }

    private Status getStatus(Date date, long time, boolean isNow) {
        Status currStatus;
        if (isNow) {
            long timeMinute;
            currStatus = this.status;
            int timeSeconds = (int)(time % 60000L);
            if (timeSeconds < 0) {
                timeSeconds = 60000 - timeSeconds;
            }
            if (currStatus.lastUpdate != (timeMinute = time - (long)timeSeconds)) {
                currStatus = FastDateFormat.getStatus(date);
                currStatus.lastUpdate = timeMinute;
                if (this.status.lastUpdate != timeMinute) {
                    this.status = currStatus;
                }
            }
        } else {
            currStatus = FastDateFormat.getStatus(date);
        }
        return currStatus;
    }

    public FastDateFormat(TimeZone zone) {
        this(FormatSpec.ISO8601_MS, zone);
    }

    public FastDateFormat(FormatSpec formatSpec, TimeZone zone) {
        this.defaultFormatSpec = formatSpec;
        this.zone = zone;
    }

    public String formatNow() {
        return this.formatNow(this.defaultFormatSpec);
    }

    public String format(long time) {
        return this.format(this.defaultFormatSpec, time);
    }

    public String format(long time, boolean isNow) {
        return this.format(this.defaultFormatSpec, time, isNow);
    }

    public String formatNow(FormatSpec formatSpec) {
        long time = System.currentTimeMillis();
        Date date = FastDateFormat.zoneDate(time, this.zone);
        Status currStatus = this.getStatus(date, time, true);
        return FastDateFormat.formatDateAndStatus(date, currStatus, formatSpec);
    }

    public String format(FormatSpec formatSpec, long time) {
        Date date = FastDateFormat.zoneDate(time, this.zone);
        Status currStatus = this.getStatus(date, time, false);
        return FastDateFormat.formatDateAndStatus(date, currStatus, formatSpec);
    }

    public String format(FormatSpec formatSpec, long time, boolean isNow) {
        Date date = FastDateFormat.zoneDate(time, this.zone);
        Status currStatus = this.getStatus(date, time, isNow);
        return FastDateFormat.formatDateAndStatus(date, currStatus, formatSpec);
    }

    public static String formatUtc(long time) {
        return FastDateFormat.formatUtc(FormatSpec.ISO8601_MS, time);
    }

    public static String format(long time, TimeZone zone) {
        return FastDateFormat.format(FormatSpec.ISO8601_MS, time, zone);
    }

    public static String formatUtc(FormatSpec formatSpec, long time) {
        return FastDateFormat.format(formatSpec, time, null);
    }

    public static String format(FormatSpec formatSpec, long time, TimeZone zone) {
        Date date = FastDateFormat.zoneDate(time, zone);
        Status status = FastDateFormat.getStatus(date);
        return FastDateFormat.formatDateAndStatus(date, status, formatSpec);
    }

    private static String formatDateAndStatus(Date date, Status status, FormatSpec formatSpec) {
        StringBuilder sb = new StringBuilder();
        sb.append(status.yearString).append(formatSpec.dateSep).append(status.monthString).append(formatSpec.dateSep).append(status.dayString);
        sb.append(formatSpec.dateTimeSep);
        sb.append(status.hourString).append(formatSpec.timeSep).append(status.minuteString).append(formatSpec.timeSep).append(FastDateFormat.pad2(date.second));
        if (formatSpec.useMs) {
            sb.append(formatSpec.decimalPoint).append(FastDateFormat.pad3(date.millisecond));
        }
        if (formatSpec.useZ && status.isZ) {
            sb.append("Z");
        } else {
            sb.append(status.zoneHour).append(formatSpec.zoneSep).append(status.zoneMinute);
        }
        return sb.toString();
    }

    public static FastDateFormat getUtcFormat() {
        return ZFormatHolder.format;
    }

    public static FastDateFormat getLocalFormat() {
        return LocalFormatHolder.format;
    }

    private static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date zoneDate(long time, TimeZone zone) {
        boolean negative;
        int offsetMillisAndUp;
        if (zone == null) {
            return FastDateFormat.utcDate(time, 0L);
        }
        TimeZone timeZone = zone;
        synchronized (timeZone) {
            offsetMillisAndUp = zone.getOffset(time);
        }
        boolean bl = negative = offsetMillisAndUp < 0;
        if (negative) {
            offsetMillisAndUp *= -1;
        }
        int zoneMillis = offsetMillisAndUp % 60000;
        int offsetMinutesAndUp = offsetMillisAndUp / 60000;
        if (zoneMillis >= 30000) {
            ++offsetMinutesAndUp;
        }
        long offset = (negative ? -60000L : 60000L) * (long)offsetMinutesAndUp;
        Date date = FastDateFormat.utcDate(time, offset);
        date.negativeZone = negative;
        date.zoneMinute = offsetMinutesAndUp % 60;
        date.zoneHour = offsetMinutesAndUp / 60;
        return date;
    }

    private static Date utcDate(long aTime, long offset) {
        int dayInYear;
        long time = aTime;
        Date date = new Date();
        int adjustedQuadCents = 0;
        if (time < 0L || offset < 0L && time + offset < 0L) {
            adjustedQuadCents = 1 - (int)(time / 12622780800000L);
            time += 12622780800000L * (long)adjustedQuadCents;
        } else if (offset > 0L && Long.MAX_VALUE - offset < time) {
            adjustedQuadCents = -1;
            time -= 12622780800000L;
        }
        date.millisecond = (int)((time += offset) % 1000L);
        date.second = (int)((time /= 1000L) % 60L);
        date.minute = (int)((time /= 60L) % 60L);
        date.hour = (int)((time /= 60L) % 24L);
        time /= 24L;
        date.year = (int)((time += 719528L) / 146097L) * 400;
        int dayInQuadCent = (int)(time % 146097L);
        if (dayInQuadCent < 366) {
            dayInYear = dayInQuadCent;
        } else {
            ++date.year;
            date.year += (dayInQuadCent -= 366) / 36524 * 100;
            int dayInCent = dayInQuadCent % 36524;
            date.year += dayInCent / 1461 * 4;
            dayInYear = dayInCent % 1461;
            int yearsInFour = dayInYear / 365;
            if (yearsInFour == 4) {
                yearsInFour = 3;
            }
            date.year += yearsInFour;
            dayInYear -= 365 * yearsInFour;
        }
        FastDateFormat.setDayAndMonth(date, dayInYear);
        if (adjustedQuadCents != 0) {
            date.year -= 400 * adjustedQuadCents;
        }
        return date;
    }

    private static void setDayAndMonth(Date date, int dayInYear) {
        int febDays;
        date.day = dayInYear + 1;
        date.month = 1;
        if (date.day > 31) {
            date.day -= 31;
            ++date.month;
        } else {
            return;
        }
        int n = febDays = FastDateFormat.isLeapYear(date.year) ? 29 : 28;
        if (date.day > febDays) {
            date.day -= febDays;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 31) {
            date.day -= 31;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 30) {
            date.day -= 30;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 31) {
            date.day -= 31;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 30) {
            date.day -= 30;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 31) {
            date.day -= 31;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 31) {
            date.day -= 31;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 30) {
            date.day -= 30;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 31) {
            date.day -= 31;
            ++date.month;
        } else {
            return;
        }
        if (date.day > 30) {
            date.day -= 30;
            ++date.month;
        }
    }

    private static int millisOfUpToTenthMillis(String tenthMillis) {
        if (tenthMillis.length() == 1) {
            return Integer.parseInt(tenthMillis) * 100;
        }
        if (tenthMillis.length() == 2) {
            return Integer.parseInt(tenthMillis) * 10;
        }
        if (tenthMillis.length() == 3) {
            return Integer.parseInt(tenthMillis);
        }
        if (tenthMillis.length() >= 4) {
            int res = Integer.parseInt(tenthMillis.substring(0, 3));
            int round = Integer.parseInt(tenthMillis.substring(3, 4));
            if (round >= 5) {
                ++res;
            }
            return res;
        }
        return 0;
    }

    private static Date parseDate(String dateString) throws ParseException {
        boolean started = false;
        boolean dashes = false;
        boolean sawTime = false;
        boolean sawPoint = false;
        boolean sawGap = false;
        for (int i = 0; i < dateString.length(); ++i) {
            char chAtPlusThree;
            char ch = dateString.charAt(i);
            if (!started) {
                if (ch == ' ') continue;
                started = true;
                continue;
            }
            if (ch == '+' || ch == 'Z') break;
            if (ch == 'T') {
                sawTime = true;
                break;
            }
            if (ch == ' ') {
                sawGap = true;
                continue;
            }
            if (sawGap && ch >= '0' && ch <= '9') {
                sawTime = true;
                break;
            }
            if (ch == '.' || ch == ',') {
                sawPoint = true;
                break;
            }
            if (ch != '-') continue;
            if (sawGap || i + 3 < dateString.length() && ((chAtPlusThree = dateString.charAt(i + 3)) == ':' || chAtPlusThree >= '0' && chAtPlusThree <= '9')) break;
            dashes = true;
            break;
        }
        if (dashes) {
            return FastDateFormat.parseDateWithPattern(dateString, dashesPattern);
        }
        if (sawTime) {
            return FastDateFormat.parseDateWithPattern(dateString, noDashesAndTimePattern);
        }
        if (sawPoint) {
            return FastDateFormat.parseDateWithPattern(dateString, allDigitsWithPointPattern);
        }
        return FastDateFormat.parseAllDigits(dateString);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(FastDateFormat.parseDate("71836209-11-05T22:26:04.699Z"));
    }

    private static Date parseAllDigits(String dateString) throws ParseException {
        Matcher m = allDigitsPattern.matcher(dateString);
        if (!m.matches()) {
            throw new ParseException("Can't parse " + dateString, 0);
        }
        boolean negativeYear = "-".equals(m.group(1));
        String digits = m.group(2);
        try {
            boolean hasExplicitZone;
            Date date = new Date();
            int len = digits.length();
            if (len <= 5) {
                date.year = Integer.parseInt(digits);
            } else if (len <= 7) {
                date.year = Integer.parseInt(digits.substring(0, len - 2));
                date.month = Integer.parseInt(digits.substring(len - 2));
            } else if (len <= 9) {
                date.year = Integer.parseInt(digits.substring(0, len - 4));
                date.month = Integer.parseInt(digits.substring(len - 4, len - 2));
                date.day = Integer.parseInt(digits.substring(len - 2));
            } else if (len <= 11) {
                date.year = Integer.parseInt(digits.substring(0, len - 6));
                date.month = Integer.parseInt(digits.substring(len - 6, len - 4));
                date.day = Integer.parseInt(digits.substring(len - 4, len - 2));
                date.hour = Integer.parseInt(digits.substring(len - 2));
            } else if (len <= 13) {
                date.year = Integer.parseInt(digits.substring(0, len - 8));
                date.month = Integer.parseInt(digits.substring(len - 8, len - 6));
                date.day = Integer.parseInt(digits.substring(len - 6, len - 4));
                date.hour = Integer.parseInt(digits.substring(len - 4, len - 2));
                date.minute = Integer.parseInt(digits.substring(len - 2));
            } else if (len <= 16) {
                date.year = Integer.parseInt(digits.substring(0, len - 10));
                date.month = Integer.parseInt(digits.substring(len - 10, len - 8));
                date.day = Integer.parseInt(digits.substring(len - 8, len - 6));
                date.hour = Integer.parseInt(digits.substring(len - 6, len - 4));
                date.minute = Integer.parseInt(digits.substring(len - 4, len - 2));
                date.second = Integer.parseInt(digits.substring(len - 2));
            } else {
                date.year = Integer.parseInt(digits.substring(0, len - 13));
                date.month = Integer.parseInt(digits.substring(len - 13, len - 11));
                date.day = Integer.parseInt(digits.substring(len - 11, len - 9));
                date.hour = Integer.parseInt(digits.substring(len - 9, len - 7));
                date.minute = Integer.parseInt(digits.substring(len - 7, len - 5));
                date.second = Integer.parseInt(digits.substring(len - 5, len - 3));
                date.millisecond = Integer.parseInt(digits.substring(len - 3));
            }
            if (negativeYear) {
                date.year = -date.year;
            }
            boolean isZ = "Z".equals(m.group(3));
            boolean bl = hasExplicitZone = m.group(4) != null;
            if (isZ && hasExplicitZone) {
                throw new ParseException("Can't parse " + dateString, 0);
            }
            date.hasZone = isZ || hasExplicitZone;
            date.negativeZone = "-".equals(m.group(4));
            if (m.group(5) != null) {
                date.zoneHour = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null) {
                date.zoneMinute = Integer.parseInt(m.group(6));
            }
            return date;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            ParseException exception = new ParseException("Error parsing " + dateString, 0);
            exception.initCause(e);
            throw exception;
        }
    }

    private static Date parseDateWithPattern(String dateString, Pattern pattern) throws ParseException {
        Matcher m = pattern.matcher(dateString);
        if (!m.matches()) {
            throw new ParseException("Can't parse " + dateString, 0);
        }
        boolean negativeYear = "-".equals(m.group(1));
        String yearString = m.group(2);
        try {
            boolean hasExplicitZone;
            Date date = new Date();
            date.year = Integer.parseInt(yearString);
            if (negativeYear) {
                date.year = -date.year;
            }
            if (m.group(3) != null) {
                date.month = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null) {
                date.day = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null) {
                date.hour = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null) {
                date.minute = Integer.parseInt(m.group(6));
            }
            if (m.group(7) != null) {
                date.second = Integer.parseInt(m.group(7));
            }
            String tenthMillis = "0";
            if (m.group(8) != null) {
                tenthMillis = m.group(8);
            }
            date.millisecond = FastDateFormat.millisOfUpToTenthMillis(tenthMillis);
            boolean isZ = "Z".equals(m.group(9));
            boolean bl = hasExplicitZone = m.group(10) != null;
            if (isZ && hasExplicitZone) {
                throw new ParseException("Can't parse " + dateString, 0);
            }
            date.hasZone = isZ || hasExplicitZone;
            date.negativeZone = "-".equals(m.group(10));
            if (m.group(11) != null) {
                date.zoneHour = Integer.parseInt(m.group(11));
            }
            if (m.group(12) != null) {
                date.zoneMinute = Integer.parseInt(m.group(12));
            }
            return date;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            ParseException exception = new ParseException("Error parsing " + dateString, 0);
            exception.initCause(e);
            throw exception;
        }
    }

    public long parse(String dateString) throws ParseException {
        return FastDateFormat.parse(dateString, this.zone);
    }

    public static long parseUtc(String dateString) throws ParseException {
        return FastDateFormat.parse(dateString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parse(String dateString, TimeZone zone) throws ParseException {
        int febDays;
        Date date = FastDateFormat.parseDate(dateString);
        boolean isLeapYear = FastDateFormat.isLeapYear(date.year);
        int year = date.year;
        long daysSinceYearZero = 146097L * (long)(year / 400);
        if ((year %= 400) >= 1) {
            daysSinceYearZero += 366L;
            --year;
        }
        daysSinceYearZero += (long)(36524 * (year / 100));
        daysSinceYearZero += (long)(1461 * ((year %= 100) / 4));
        long daysSince1970 = (daysSinceYearZero += (long)(365 * (year %= 4))) - 719528L;
        if (date.month > 1) {
            daysSince1970 += 31L;
        }
        int n = febDays = isLeapYear ? 29 : 28;
        if (date.month > 2) {
            daysSince1970 += (long)febDays;
        }
        if (date.month > 3) {
            daysSince1970 += 31L;
        }
        if (date.month > 4) {
            daysSince1970 += 30L;
        }
        if (date.month > 5) {
            daysSince1970 += 31L;
        }
        if (date.month > 6) {
            daysSince1970 += 30L;
        }
        if (date.month > 7) {
            daysSince1970 += 31L;
        }
        if (date.month > 8) {
            daysSince1970 += 31L;
        }
        if (date.month > 9) {
            daysSince1970 += 30L;
        }
        if (date.month > 10) {
            daysSince1970 += 31L;
        }
        if (date.month > 11) {
            daysSince1970 += 30L;
        }
        long res = 86400000L * (daysSince1970 += (long)(date.day - 1)) + 3600000L * (long)date.hour + 60000L * (long)date.minute + 1000L * (long)date.second + (long)date.millisecond;
        if (date.hasZone) {
            res -= (long)(date.negativeZone ? -1 : 1) * (3600000L * (long)date.zoneHour + 60000L * (long)date.zoneMinute);
        } else if (zone != null) {
            TimeZone timeZone = zone;
            synchronized (timeZone) {
                long offsetRes = res - (long)zone.getOffset(res);
                res -= (long)zone.getOffset(offsetRes);
            }
        }
        return res;
    }

    private static class LocalFormatHolder {
        static FastDateFormat format = new FastDateFormat(TimeZone.getDefault());

        private LocalFormatHolder() {
        }
    }

    private static class ZFormatHolder {
        static FastDateFormat format = new FastDateFormat(null);

        private ZFormatHolder() {
        }
    }

    public static class FormatSpec {
        String dateSep;
        String dateTimeSep;
        String timeSep;
        String zoneSep;
        String decimalPoint;
        boolean useMs;
        boolean useZ;
        public static final FormatSpec ISO8601_MS = new FormatSpec("-", "T", ":", ":", ".", true, true);
        public static final FormatSpec ISO8601_NO_MS = new FormatSpec("-", "T", ":", ":", ".", false, true);

        public FormatSpec(String dateSep, String dateTimeSep, String timeSep, String zoneSep, String decimalPoint, boolean useMs, boolean useZ) {
            this.dateSep = dateSep;
            this.dateTimeSep = dateTimeSep;
            this.timeSep = timeSep;
            this.zoneSep = zoneSep;
            this.decimalPoint = decimalPoint;
            this.useMs = useMs;
            this.useZ = useZ;
        }
    }

    private static class Status {
        String yearString;
        String monthString;
        String dayString;
        String hourString;
        String minuteString;
        String zoneHour;
        String zoneMinute;
        boolean isZ;
        long lastUpdate = -1L;

        private Status() {
        }
    }

    private static class Date {
        int year;
        int month = 1;
        int day = 1;
        int hour;
        int minute;
        int second;
        int millisecond;
        boolean hasZone = true;
        boolean negativeZone;
        int zoneHour;
        int zoneMinute;

        private Date() {
        }

        public String toString() {
            return "Date [year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", millisecond=" + this.millisecond + ", hasZone=" + this.hasZone + ", negativeZone=" + this.negativeZone + ", zoneHour=" + this.zoneHour + ", zoneMinute=" + this.zoneMinute + "]";
        }
    }
}

