/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.cnri.util.StringUtils;

public abstract class ServletUtil {
    private ServletUtil() {
    }

    public static String pathMatching(String full, String prefix) {
        return ServletUtil.pathMatching(full, prefix, true);
    }

    public static String pathExcluding(String full, String prefix) {
        return ServletUtil.pathExcluding(full, prefix, true);
    }

    public static String pathMatching(String full, String prefix, boolean prefixMayBeEncoded) {
        String suffix;
        if (full.startsWith(prefix) && ((suffix = full.substring(prefix.length())).isEmpty() || suffix.startsWith("/") || suffix.startsWith("%2F") || suffix.startsWith("%2f"))) {
            return prefix;
        }
        int slashes = ServletUtil.countSlashesOrEncodedSlashes(prefix, prefixMayBeEncoded);
        int index = ServletUtil.indexOfNthSlashOrEncodedSlash(full, slashes + 1);
        String prefixInFull = index >= 0 ? full.substring(0, index) : full;
        if (ServletUtil.urlDecode(prefixInFull).equals(ServletUtil.urlDecode(prefix))) {
            return prefixInFull;
        }
        return prefix;
    }

    public static String pathExcluding(String full, String prefix, boolean prefixMayBeEncoded) {
        String suffix;
        if (full.startsWith(prefix) && ((suffix = full.substring(prefix.length())).isEmpty() || suffix.startsWith("/") || suffix.startsWith("%2F") || suffix.startsWith("%2f"))) {
            return suffix;
        }
        int slashes = ServletUtil.countSlashesOrEncodedSlashes(prefix, prefixMayBeEncoded);
        int index = ServletUtil.indexOfNthSlashOrEncodedSlash(full, slashes + 1);
        String prefixInFull = index >= 0 ? full.substring(0, index) : full;
        if (ServletUtil.urlDecode(prefixInFull).equals(ServletUtil.urlDecode(prefix))) {
            if (index < 0) {
                return "";
            }
            return full.substring(index);
        }
        return full;
    }

    public static int indexOfNextSlashOrEncodedSlash(String string, int start) {
        int slashIndex = string.indexOf(47, start);
        int twoEffIndex = string.indexOf("%2F", start);
        if (slashIndex < 0 || 0 <= twoEffIndex && twoEffIndex < slashIndex) {
            slashIndex = twoEffIndex;
        }
        twoEffIndex = string.indexOf("%2f", start);
        if (slashIndex < 0 || 0 <= twoEffIndex && twoEffIndex < slashIndex) {
            slashIndex = twoEffIndex;
        }
        return slashIndex;
    }

    public static int countSlashesOrEncodedSlashes(String string, boolean stringMayBeEncoded) {
        int count = 0;
        int lastIndex = -1;
        while (true) {
            int nextIndex;
            int n = nextIndex = stringMayBeEncoded ? ServletUtil.indexOfNextSlashOrEncodedSlash(string, lastIndex + 1) : string.indexOf(47, lastIndex + 1);
            if (nextIndex < 0) {
                return count;
            }
            ++count;
            lastIndex = nextIndex;
        }
    }

    public static int indexOfNthSlashOrEncodedSlash(String string, int n) {
        int lastIndex = -1;
        for (int i = 0; i < n; ++i) {
            if ((lastIndex = ServletUtil.indexOfNextSlashOrEncodedSlash(string, lastIndex + 1)) >= 0) continue;
            return i - n;
        }
        return lastIndex;
    }

    public static String urlDecode(String s) {
        return StringUtils.decodeURLIgnorePlus(s);
    }

    public static boolean isThisMyIpAddress(String addrString) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(addrString);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (addr.isLoopbackAddress() || addr.isAnyLocalAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }
}

