/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public abstract class StreamUtil {
    public static byte[] readFully(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) >= 0) {
            bout.write(buf, 0, r);
        }
        return bout.toByteArray();
    }

    public static String readFully(Reader in) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        while ((r = in.read(buf)) >= 0) {
            sb.append(buf, 0, r);
        }
        return sb.toString();
    }

    @Deprecated
    public static byte[] readFully(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    @Deprecated
    public static String readFullyAsString(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static byte[] readFully(String file) throws IOException {
        return Files.readAllBytes(Paths.get(file, new String[0]));
    }

    @Deprecated
    public static String readFullyAsString(String file) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(file, new String[0]));
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

