/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class StringUtils {
    private static final char[] HEX_VALUES;
    private static BitSet safeURL;
    private static BitSet safeURLPath;
    private static BitSet safeURLComponentMinimal;

    public static final String backslash(String str, String escChars) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int currPos = 0; currPos < len; ++currPos) {
            char ch = str.charAt(currPos);
            if (ch == '\\' || escChars.indexOf(ch) >= 0) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String unbackslash(String str) {
        int len = str.length();
        int currPos = 0;
        char backslash = '\\';
        StringBuilder sb = new StringBuilder(str.length());
        while (currPos < len) {
            char ch;
            if ((ch = str.charAt(currPos++)) == backslash && currPos < len) {
                sb.append(str.charAt(currPos++));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String decodeURLIgnorePlus(String str) {
        byte[] utf8Buf = new byte[str.length()];
        int utf8Loc = 0;
        int strLoc = 0;
        int strLen = str.length();
        while (strLoc < strLen) {
            char ch;
            if ((ch = str.charAt(strLoc++)) == '%' && strLoc + 2 <= strLen) {
                utf8Buf[utf8Loc++] = StringUtils.decodeHexByte(str.charAt(strLoc++), str.charAt(strLoc++));
                continue;
            }
            utf8Buf[utf8Loc++] = (byte)ch;
        }
        try {
            return new String(utf8Buf, 0, utf8Loc, "UTF8");
        }
        catch (Exception e) {
            return new String(utf8Buf, 0, utf8Loc);
        }
    }

    public static String decodeURL(String str) {
        byte[] utf8Buf = new byte[str.length()];
        int utf8Loc = 0;
        int strLoc = 0;
        int strLen = str.length();
        while (strLoc < strLen) {
            char ch;
            if ((ch = str.charAt(strLoc++)) == '%' && strLoc + 2 <= strLen) {
                utf8Buf[utf8Loc++] = StringUtils.decodeHexByte(str.charAt(strLoc++), str.charAt(strLoc++));
                continue;
            }
            if (ch == '+') {
                utf8Buf[utf8Loc++] = 32;
                continue;
            }
            utf8Buf[utf8Loc++] = (byte)ch;
        }
        try {
            return new String(utf8Buf, 0, utf8Loc, "UTF8");
        }
        catch (Exception e) {
            return new String(utf8Buf, 0, utf8Loc);
        }
    }

    public static final byte decodeHexByte(char ch1, char ch2) {
        char n1 = (char)(ch1 >= '0' && ch1 <= '9' ? ch1 - 48 : (ch1 >= 'a' && ch1 <= 'z' ? ch1 - 97 + 10 : ch1 - 65 + 10));
        char n2 = (char)(ch2 >= '0' && ch2 <= '9' ? ch2 - 48 : (ch2 >= 'a' && ch2 <= 'z' ? ch2 - 97 + 10 : ch2 - 65 + 10));
        return (byte)(n1 << 4 | n2);
    }

    public static String encodeHexChar(byte b) {
        StringBuilder sb = new StringBuilder();
        sb.append(HEX_VALUES[(b & 0xF0) >> 4]);
        sb.append(HEX_VALUES[b & 0xF]);
        return sb.toString();
    }

    public static final String padr(String str, int n, char padchar) {
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() < n) {
            sb.append(padchar);
        }
        return sb.toString();
    }

    public static final String padl(String str, int n, char padchar) {
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() < n) {
            sb.insert(0, padchar);
        }
        return sb.toString();
    }

    public static String cgiEscape(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                sb.append("&#39;");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void xmlEscape(Appendable buf, CharSequence s, boolean quot, boolean apos) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' && quot) {
                buf.append("&quot;");
                continue;
            }
            if (c == '\'' && apos) {
                buf.append("&#39;");
                continue;
            }
            if (c == '\t') {
                buf.append("&#x9;");
                continue;
            }
            if (c == '\r') {
                buf.append("&#xD;");
                continue;
            }
            if (c == '\n' && (quot || apos)) {
                buf.append("&#xA;");
                continue;
            }
            buf.append(c);
        }
    }

    public static String xmlEscape(CharSequence s, boolean attribute) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtils.xmlEscape(sb, s, attribute, attribute);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public static String xmlEscape(CharSequence s) {
        return StringUtils.xmlEscape(s, true);
    }

    public static final String htmlEscapeWhitespace(String str) {
        return StringUtils.htmlEscapeWhitespace(str, false);
    }

    public static final String htmlEscapeWhitespaceNonBreakingSpaces(String str) {
        return StringUtils.htmlEscapeWhitespace(str, true);
    }

    private static final String htmlEscapeWhitespace(String str, boolean noBreaks) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                sb.append("&#39;");
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                sb.append("<br />");
                continue;
            }
            if (ch == '\t') {
                sb.append("&nbsp;&nbsp;&nbsp&nbsp;");
                continue;
            }
            if (ch == ' ' && noBreaks) {
                sb.append("&nbsp;");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String sqlEscape(String str) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                sb.append("''");
                continue;
            }
            if (ch == '\n') {
                sb.append("\\n");
                continue;
            }
            if (ch == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String encodeURLComponent(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String encodeURL(String s, BitSet safeChars) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (safeChars.get(b & 0xFF)) {
                sb.append((char)b);
                continue;
            }
            sb.append("%");
            sb.append(StringUtils.encodeHexChar(b));
        }
        return sb.toString();
    }

    public static String encodeURL(String s) {
        return StringUtils.encodeURL(s, safeURL);
    }

    public static String encodeURLForAttr(String s) {
        return StringUtils.cgiEscape(StringUtils.encodeURL(s));
    }

    public static String encodeURLPath(String s) {
        return StringUtils.encodeURL(s, safeURLPath);
    }

    public static String encodeURLComponentMinimal(String s) {
        return StringUtils.encodeURL(s, safeURLComponentMinimal);
    }

    static {
        int i;
        int ch;
        HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeURL = new BitSet(256);
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            safeURL.set(ch);
        }
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            safeURL.set(ch);
        }
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            safeURL.set(ch);
        }
        String unreserved = "-._~";
        String pathGenDelims = ":@/";
        String safeSubDelims1 = "!$()*,";
        String safeSubDelims2 = ";=";
        String unsafeSubDelims = "+&'";
        String fullURIOnlyGenDelims = "?#[]";
        String s = unreserved + safeSubDelims1 + pathGenDelims;
        for (i = 0; i < s.length(); ++i) {
            safeURL.set(s.charAt(i));
        }
        safeURLComponentMinimal = (BitSet)safeURL.clone();
        s = safeSubDelims2;
        for (i = 0; i < s.length(); ++i) {
            safeURL.set(s.charAt(i));
        }
        safeURLPath = (BitSet)safeURL.clone();
        s = unsafeSubDelims + fullURIOnlyGenDelims;
        for (i = 0; i < s.length(); ++i) {
            safeURL.set(s.charAt(i));
        }
        safeURL.set(37, true);
    }
}

