/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.Should;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class DomElement {
    private final WebDriver driver;
    private final String selector;
    private final Retry retry;

    DomElement(WebDriver driver, String selector) {
        this.driver = driver;
        this.selector = selector;
        this.retry = new Retry(30L, TimeUnit.SECONDS);
    }

    public Should should() {
        return new Should(this.driver, this.selector, 5L, TimeUnit.SECONDS);
    }

    public Should shouldWithin(long duration, TimeUnit timeUnit) {
        return new Should(this.driver, this.selector, duration, timeUnit);
    }

    public String getText() {
        System.out.println(" - " + this.selector + "." + "getText()");
        return this.find().getText();
    }

    public void fill(CharSequence text) {
        this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    public void submit() {
        this.execute("submit", element -> element.submit());
    }

    public void click() {
        this.execute("click", element -> element.click());
    }

    private void execute(String message, Consumer<WebElement> action) {
        System.out.println(" - " + this.selector + "." + message);
        this.retry.execute(() -> this.find(), action);
    }

    private WebElement find() {
        return this.driver.findElement(By.cssSelector((String)this.selector));
    }
}

