/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import net.codecrete.qrbill.canvas.Canvas;

public class Graphics2DCanvas
extends AbstractCanvas {
    private Graphics2D graphics;
    private boolean ownsGraphics;
    private float offsetX;
    private float offsetY;
    private Path2D.Double currentPath;
    private float coordinateScale;
    private float fontScale;
    private static final Pattern QUOTED_SPLITTER = Pattern.compile("(?:^|,)(\"[^\"]+\"|[^,]*)");

    public Graphics2DCanvas(String fontFamily) {
        this.setupFontMetrics(this.findFontFamily(fontFamily));
    }

    public Graphics2DCanvas(Graphics2D graphics, float offsetX, float offsetY, float scale, String fontFamily) {
        this.setupFontMetrics(fontFamily);
        this.setOffset(offsetX, offsetY);
        this.initGraphics(graphics, false, scale);
    }

    protected void initGraphics(Graphics2D graphics, boolean ownsGraphics, float scale) {
        this.graphics = graphics;
        this.ownsGraphics = ownsGraphics;
        this.coordinateScale = scale;
        this.fontScale = (float)((double)scale * 25.4 / 72.0);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setTransformation(0.0, 0.0, 0.0, 1.0, 1.0);
    }

    protected void setOffset(float x, float y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    @Override
    public void close() {
        if (this.ownsGraphics) {
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    private String findFontFamily(String fontFamilyList) {
        for (String family : Graphics2DCanvas.splitCommaSeparated(fontFamilyList)) {
            Font font = new Font(family, 0, 12);
            if (!font.getFamily().toLowerCase(Locale.US).contains(family.toLowerCase(Locale.US))) continue;
            return family;
        }
        return fontFamilyList;
    }

    private static List<String> splitCommaSeparated(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = QUOTED_SPLITTER.matcher(input);
        while (matcher.find()) {
            String match = matcher.group(1).trim();
            if (match.charAt(0) == '\"' && match.charAt(match.length() - 1) == '\"') {
                match = match.substring(1, match.length() - 1);
            }
            result.add(match);
        }
        return result;
    }

    @Override
    public void setTransformation(double translateX, double translateY, double rotate, double scaleX, double scaleY) {
        AffineTransform at = new AffineTransform();
        at.translate((double)this.offsetX + (translateX *= (double)this.coordinateScale), (double)this.offsetY - (translateY *= (double)this.coordinateScale));
        if (rotate != 0.0) {
            at.rotate(-rotate);
        }
        if (scaleX != 1.0 || scaleY != 1.0) {
            at.scale(scaleX, scaleY);
        }
        this.graphics.setTransform(at);
    }

    @Override
    public void putText(String text, double x, double y, int fontSize, boolean isBold) {
        this.graphics.setColor(new Color(0));
        Font font = new Font(this.fontMetrics.getFirstFontFamily(), isBold ? 1 : 0, (int)((double)((float)fontSize * this.fontScale) + 0.5));
        this.graphics.setFont(font);
        this.graphics.drawString(text, (float)(x *= (double)this.coordinateScale), (float)(y *= (double)(-this.coordinateScale)));
    }

    @Override
    public void startPath() {
        this.currentPath = new Path2D.Double(1);
    }

    @Override
    public void moveTo(double x, double y) {
        this.currentPath.moveTo(x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
    }

    @Override
    public void lineTo(double x, double y) {
        this.currentPath.lineTo(x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
    }

    @Override
    public void cubicCurveTo(double x1, double y1, double x2, double y2, double x, double y) {
        this.currentPath.curveTo(x1 *= (double)this.coordinateScale, y1 *= (double)(-this.coordinateScale), x2 *= (double)this.coordinateScale, y2 *= (double)(-this.coordinateScale), x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
    }

    @Override
    public void addRectangle(double x, double y, double width, double height) {
        this.currentPath.moveTo(x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
        this.currentPath.lineTo(x, y + (height *= (double)(-this.coordinateScale)));
        this.currentPath.lineTo(x + (width *= (double)this.coordinateScale), y + height);
        this.currentPath.lineTo(x + width, y);
        this.currentPath.closePath();
    }

    @Override
    public void closeSubpath() {
        this.currentPath.closePath();
    }

    @Override
    public void fillPath(int color, boolean smoothing) {
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
        this.graphics.setColor(new Color(color));
        this.graphics.fill(this.currentPath);
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }

    @Override
    public void strokePath(double strokeWidth, int color, Canvas.LineStyle lineStyle, boolean smoothing) {
        BasicStroke stroke;
        this.graphics.setColor(new Color(color));
        switch (lineStyle) {
            case Dashed: {
                stroke = new BasicStroke((float)(strokeWidth * (double)this.fontScale), 0, 0, 10.0f, new float[]{4.0f * (float)strokeWidth * this.fontScale}, 0.0f);
                break;
            }
            case Dotted: {
                stroke = new BasicStroke((float)(strokeWidth * (double)this.fontScale), 1, 0, 10.0f, new float[]{0.0f, 3.0f * (float)strokeWidth * this.fontScale}, 0.0f);
                break;
            }
            default: {
                stroke = new BasicStroke((float)(strokeWidth * (double)this.fontScale), 0, 0);
            }
        }
        this.graphics.setStroke(stroke);
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
        this.graphics.draw(this.currentPath);
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }
}

